/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.CallAbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.FunMatcherKt;
import org.sonarsource.kotlin.checks.AndroidBroadcastingCheck;
import org.sonarsource.kotlin.checks.AndroidBroadcastingCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S5320")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J\"\u0010\u0017\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J\"\u0010\u0018\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J\"\u0010\u0019\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/AndroidBroadcastingCheck;", "Lorg/sonarsource/kotlin/api/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "isSendBroadcast", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "name", "", "argumentsByIndex", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isSendBroadcastAsUser", "isSendOrderedBroadcast", "isSendOrderedBroadcastAsUser", "sonar-kotlin-plugin"})
public final class AndroidBroadcastingCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, null, null, null, null, "android.content.Context", false, null, null, null, null, functionsToVisit.1.INSTANCE, 2015, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            return;
        }
        List<ResolvedValueArgument> arguments2 = list2;
        String string2 = resolvedCall2.getResultingDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "resolvedCall.resultingDescriptor.name.asString()");
        String name = string2;
        BindingContext $this$visitFunctionCall_u24lambda_u2d0 = kotlinFileContext.getBindingContext();
        boolean bl = false;
        boolean bl2 = AndroidBroadcastingCheckKt.access$getSTICKY_BROADCAST_NAMES$p().contains(name) || this.isSendBroadcast($this$visitFunctionCall_u24lambda_u2d0, name, arguments2) || this.isSendBroadcastAsUser($this$visitFunctionCall_u24lambda_u2d0, name, arguments2) || this.isSendOrderedBroadcast($this$visitFunctionCall_u24lambda_u2d0, name, arguments2) || this.isSendOrderedBroadcastAsUser($this$visitFunctionCall_u24lambda_u2d0, name, arguments2);
        if (bl2) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Make sure that broadcasting intents is safe here.", null, null, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcastAsUser(BindingContext $this$isSendOrderedBroadcastAsUser, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcastAsUser")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (resolvedValueArgument == null) return false;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendOrderedBroadcastAsUser);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcast(BindingContext $this$isSendOrderedBroadcast, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcast")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (resolvedValueArgument == null) return false;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendOrderedBroadcast);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcastAsUser(BindingContext $this$isSendBroadcastAsUser, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcast")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (resolvedValueArgument == null) return true;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendBroadcastAsUser);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcast(BindingContext $this$isSendBroadcast, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcastAsUser")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (resolvedValueArgument == null) return true;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendBroadcast);
        if (!bl) return false;
        return true;
    }
}

