/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1940")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanInversionCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitUnaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "Companion", "sonar-kotlin-plugin"})
public final class BooleanInversionCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<KtSingleValueToken, String> OPERATORS;

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EXCL)) {
            return;
        }
        KtExpression ktExpression = expression2.getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression innerExpression = this.skipParentheses$sonar_kotlin_plugin(ktExpression);
        if (innerExpression instanceof KtBinaryExpression) {
            String oppositeOperator = OPERATORS.get(((KtBinaryExpression)innerExpression).getOperationToken());
            if (oppositeOperator != null) {
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, expression2, "Use the opposite operator (\"" + oppositeOperator + "\") instead.", null, null, 12, null);
            }
        } else if (innerExpression instanceof KtIsExpression) {
            String oppositeOperator = ((KtIsExpression)innerExpression).isNegated() ? "is" : "!is";
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, expression2, "Use the opposite operator (\"" + oppositeOperator + "\") instead.", null, null, 12, null);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(KtTokens.EQEQ, "!="), TuplesKt.to(KtTokens.EXCLEQ, "=="), TuplesKt.to(KtTokens.EQEQEQ, "!=="), TuplesKt.to(KtTokens.EXCLEQEQEQ, "==="), TuplesKt.to(KtTokens.LT, ">="), TuplesKt.to(KtTokens.GT, "<="), TuplesKt.to(KtTokens.LTEQ, ">"), TuplesKt.to(KtTokens.GTEQ, "<")};
        OPERATORS = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanInversionCheck$Companion;", "", "()V", "OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

