/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S6312")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/CoroutineScopeFunSuspendingCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class CoroutineScopeFunSuspendingCheck
extends AbstractCheck {
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        block12: {
            KtTypeReference receiverType;
            PsiElement suspendModifier2;
            block11: {
                boolean bl;
                block10: {
                    Intrinsics.checkNotNullParameter(function2, "function");
                    Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                    PsiElement psiElement = ApiExtensionsKt.suspendModifier(function2);
                    if (psiElement == null) {
                        return;
                    }
                    suspendModifier2 = psiElement;
                    KtTypeReference ktTypeReference = function2.getReceiverTypeReference();
                    if (ktTypeReference == null) {
                        return;
                    }
                    receiverType = ktTypeReference;
                    KotlinType kotlinType = (KotlinType)kotlinFileContext.getBindingContext().get(BindingContext.TYPE, receiverType);
                    if (kotlinType == null) {
                        return;
                    }
                    KotlinType resolvedReceiverType = kotlinType;
                    if (Intrinsics.areEqual(DescriptorUtilsKt.getJetTypeFqName(resolvedReceiverType, false), "kotlinx.coroutines.CoroutineScope")) break block11;
                    Iterable $this$any$iv = TypeUtilsKt.supertypes(resolvedReceiverType);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(DescriptorUtilsKt.getJetTypeFqName(it, false), "kotlinx.coroutines.CoroutineScope")) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block12;
            }
            List<SecondaryLocation> secondaries = CollectionsKt.listOf(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, receiverType), null, 2, null));
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, suspendModifier2, "Extension functions on CoroutineScope should not be suspending.", secondaries, null, 8, null);
        }
    }
}

