/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.sonarsource.kotlin.checks.UnnecessaryImportsCheckKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/sonarsource/kotlin/checks/DataCollector;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "arrayAccesses", "", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "calls", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "delegateImports", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kDocLinks", "", "references", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "result", "Lorg/sonarsource/kotlin/checks/DataCollector$DataCollectionResult;", "getResult", "()Lorg/sonarsource/kotlin/checks/DataCollector$DataCollectionResult;", "collectFromKDocComments", "", "comments", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "recurse", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitArrayAccessExpression", "expression", "visitCallExpression", "visitPropertyDelegate", "delegate", "visitReferenceExpression", "DataCollectionResult", "sonar-kotlin-plugin"})
final class DataCollector
extends KtTreeVisitorVoid {
    @NotNull
    private final KtFile file;
    @NotNull
    private final List<KtReferenceExpression> references;
    @NotNull
    private final List<KtArrayAccessExpression> arrayAccesses;
    @NotNull
    private final Set<String> kDocLinks;
    @NotNull
    private final Set<KtPropertyDelegate> delegateImports;
    @NotNull
    private final Set<KtCallExpression> calls;

    public DataCollector(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.file = file2;
        this.references = new ArrayList();
        this.arrayAccesses = new ArrayList();
        this.kDocLinks = new LinkedHashSet();
        this.delegateImports = new LinkedHashSet();
        this.calls = new LinkedHashSet();
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    @NotNull
    public final DataCollectionResult getResult() {
        return new DataCollectionResult((Collection<? extends KtReferenceExpression>)this.references, (Collection<? extends KtArrayAccessExpression>)this.arrayAccesses, (Collection<String>)this.kDocLinks, (Collection<? extends KtPropertyDelegate>)this.delegateImports, (Collection<? extends KtCallExpression>)this.calls);
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
        KtReferenceExpression ktReferenceExpression;
        KtReferenceExpression ktReferenceExpression2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtReferenceExpression it = ktReferenceExpression2 = expression2;
        boolean bl = false;
        PsiElement[] psiElementArray = it.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "it.children");
        KtReferenceExpression ktReferenceExpression3 = ktReferenceExpression = !(!(((Object[])psiElementArray).length == 0) || UnnecessaryImportsCheckKt.access$isQualifiedUserType(it)) ? ktReferenceExpression2 : null;
        if (ktReferenceExpression != null) {
            it = ktReferenceExpression;
            boolean bl2 = false;
            this.references.add(it);
        }
        this.recurse(expression2);
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.arrayAccesses.add(expression2);
        this.recurse(expression2);
    }

    @Override
    public void visitPropertyDelegate(@NotNull KtPropertyDelegate delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.delegateImports.add(delegate);
        this.recurse(delegate);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.calls.add(expression2);
        this.recurse(expression2);
    }

    private final void recurse(KtElement element) {
        super.visitElement(element);
    }

    public final void collectFromKDocComments(@NotNull Sequence<KDocLink> comments) {
        Intrinsics.checkNotNullParameter(comments, "comments");
        Sequence<KDocLink> $this$forEach$iv = comments;
        boolean $i$f$forEach = false;
        Iterator<KDocLink> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            KDocLink element$iv;
            KDocLink it = element$iv = iterator2.next();
            boolean bl = false;
            this.kDocLinks.add(StringsKt.substringBefore$default(it.getLinkText(), '.', null, 2, null));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003JY\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/sonarsource/kotlin/checks/DataCollector$DataCollectionResult;", "", "references", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "arrayAccesses", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "kDocLinks", "", "delegateImports", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "calls", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getArrayAccesses", "()Ljava/util/Collection;", "getCalls", "getDelegateImports", "getKDocLinks", "getReferences", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "sonar-kotlin-plugin"})
    public static final class DataCollectionResult {
        @NotNull
        private final Collection<KtReferenceExpression> references;
        @NotNull
        private final Collection<KtArrayAccessExpression> arrayAccesses;
        @NotNull
        private final Collection<String> kDocLinks;
        @NotNull
        private final Collection<KtPropertyDelegate> delegateImports;
        @NotNull
        private final Collection<KtCallExpression> calls;

        public DataCollectionResult(@NotNull Collection<? extends KtReferenceExpression> references, @NotNull Collection<? extends KtArrayAccessExpression> arrayAccesses, @NotNull Collection<String> kDocLinks, @NotNull Collection<? extends KtPropertyDelegate> delegateImports, @NotNull Collection<? extends KtCallExpression> calls) {
            Intrinsics.checkNotNullParameter(references, "references");
            Intrinsics.checkNotNullParameter(arrayAccesses, "arrayAccesses");
            Intrinsics.checkNotNullParameter(kDocLinks, "kDocLinks");
            Intrinsics.checkNotNullParameter(delegateImports, "delegateImports");
            Intrinsics.checkNotNullParameter(calls, "calls");
            this.references = references;
            this.arrayAccesses = arrayAccesses;
            this.kDocLinks = kDocLinks;
            this.delegateImports = delegateImports;
            this.calls = calls;
        }

        @NotNull
        public final Collection<KtReferenceExpression> getReferences() {
            return this.references;
        }

        @NotNull
        public final Collection<KtArrayAccessExpression> getArrayAccesses() {
            return this.arrayAccesses;
        }

        @NotNull
        public final Collection<String> getKDocLinks() {
            return this.kDocLinks;
        }

        @NotNull
        public final Collection<KtPropertyDelegate> getDelegateImports() {
            return this.delegateImports;
        }

        @NotNull
        public final Collection<KtCallExpression> getCalls() {
            return this.calls;
        }

        @NotNull
        public final Collection<KtReferenceExpression> component1() {
            return this.references;
        }

        @NotNull
        public final Collection<KtArrayAccessExpression> component2() {
            return this.arrayAccesses;
        }

        @NotNull
        public final Collection<String> component3() {
            return this.kDocLinks;
        }

        @NotNull
        public final Collection<KtPropertyDelegate> component4() {
            return this.delegateImports;
        }

        @NotNull
        public final Collection<KtCallExpression> component5() {
            return this.calls;
        }

        @NotNull
        public final DataCollectionResult copy(@NotNull Collection<? extends KtReferenceExpression> references, @NotNull Collection<? extends KtArrayAccessExpression> arrayAccesses, @NotNull Collection<String> kDocLinks, @NotNull Collection<? extends KtPropertyDelegate> delegateImports, @NotNull Collection<? extends KtCallExpression> calls) {
            Intrinsics.checkNotNullParameter(references, "references");
            Intrinsics.checkNotNullParameter(arrayAccesses, "arrayAccesses");
            Intrinsics.checkNotNullParameter(kDocLinks, "kDocLinks");
            Intrinsics.checkNotNullParameter(delegateImports, "delegateImports");
            Intrinsics.checkNotNullParameter(calls, "calls");
            return new DataCollectionResult(references, arrayAccesses, kDocLinks, delegateImports, calls);
        }

        public static /* synthetic */ DataCollectionResult copy$default(DataCollectionResult dataCollectionResult, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, int n, Object object) {
            if ((n & 1) != 0) {
                collection = dataCollectionResult.references;
            }
            if ((n & 2) != 0) {
                collection2 = dataCollectionResult.arrayAccesses;
            }
            if ((n & 4) != 0) {
                collection3 = dataCollectionResult.kDocLinks;
            }
            if ((n & 8) != 0) {
                collection4 = dataCollectionResult.delegateImports;
            }
            if ((n & 0x10) != 0) {
                collection5 = dataCollectionResult.calls;
            }
            return dataCollectionResult.copy(collection, collection2, collection3, collection4, collection5);
        }

        @NotNull
        public String toString() {
            return "DataCollectionResult(references=" + this.references + ", arrayAccesses=" + this.arrayAccesses + ", kDocLinks=" + this.kDocLinks + ", delegateImports=" + this.delegateImports + ", calls=" + this.calls + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.references).hashCode();
            result2 = result2 * 31 + ((Object)this.arrayAccesses).hashCode();
            result2 = result2 * 31 + ((Object)this.kDocLinks).hashCode();
            result2 = result2 * 31 + ((Object)this.delegateImports).hashCode();
            result2 = result2 * 31 + ((Object)this.calls).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataCollectionResult)) {
                return false;
            }
            DataCollectionResult dataCollectionResult = (DataCollectionResult)other;
            if (!Intrinsics.areEqual(this.references, dataCollectionResult.references)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arrayAccesses, dataCollectionResult.arrayAccesses)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.kDocLinks, dataCollectionResult.kDocLinks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.delegateImports, dataCollectionResult.delegateImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.calls, dataCollectionResult.calls);
        }
    }
}

