/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1451")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/sonarsource/kotlin/checks/FileHeaderCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "expectedLines", "", "", "headerFormat", "getHeaderFormat", "()Ljava/lang/String;", "setHeaderFormat", "(Ljava/lang/String;)V", "isRegularExpression", "", "()Z", "setRegularExpression", "(Z)V", "searchPattern", "Lkotlin/text/Regex;", "hasExpectedHeader", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialize", "", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "visitKtFile", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class FileHeaderCheck
extends AbstractCheck {
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    @NotNull
    private String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    private boolean isRegularExpression;
    private Regex searchPattern;
    private List<String> expectedLines;

    @NotNull
    public final String getHeaderFormat() {
        return this.headerFormat;
    }

    public final void setHeaderFormat(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.headerFormat = string2;
    }

    public final boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public final void setRegularExpression(boolean bl) {
        this.isRegularExpression = bl;
    }

    @Override
    public void initialize(@NotNull RuleKey ruleKey) {
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        super.initialize(ruleKey);
        if (this.isRegularExpression) {
            try {
                this.searchPattern = new Regex("^" + this.headerFormat);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + this.getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        } else {
            this.expectedLines = StringsKt.lines(this.headerFormat);
        }
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.hasExpectedHeader(file2)) {
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, null, "Add or update the header of this file.", null, null, 12, null);
        }
    }

    private final boolean hasExpectedHeader(KtFile file2) {
        boolean bl;
        if (this.isRegularExpression) {
            Regex regex = this.searchPattern;
            if (regex == null) {
                Intrinsics.throwUninitializedPropertyAccessException("searchPattern");
                regex = null;
            }
            String string2 = file2.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "file.text");
            bl = Regex.find$default(regex, string2, 0, 2, null) != null;
        } else {
            List<String> list2 = this.expectedLines;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expectedLines");
                list2 = null;
            }
            String string3 = file2.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "file.text");
            Sequence<String> sequence2 = StringsKt.lineSequence(string3);
            List<String> list3 = this.expectedLines;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expectedLines");
                list3 = null;
            }
            bl = Intrinsics.areEqual(list2, SequencesKt.toList(SequencesKt.take(sequence2, list3.size())));
        }
        return bl;
    }
}

