/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020'H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/sonarsource/kotlin/checks/FinallyBlockVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "report", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "(Lkotlin/jvm/functions/Function1;)V", "alreadyEnteredFinallyBlock", "", "functionDepthCounter", "", "loopDepthCounter", "stackedLabels", "Ljava/util/Stack;", "", "checkAndVisit", "depthCounter", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitFinallySection", "finallySection", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "sonar-kotlin-plugin"})
final class FinallyBlockVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Function1<KtExpression, Unit> report;
    private int loopDepthCounter;
    private int functionDepthCounter;
    @NotNull
    private final Stack<String> stackedLabels;
    private boolean alreadyEnteredFinallyBlock;

    public FinallyBlockVisitor(@NotNull Function1<? super KtExpression, Unit> report2) {
        Intrinsics.checkNotNullParameter(report2, "report");
        this.report = report2;
        this.stackedLabels = new Stack();
    }

    @Override
    public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.stackedLabels.push(expression2.getName());
        super.visitLabeledExpression(expression2);
        this.stackedLabels.pop();
    }

    @Override
    public void visitFinallySection(@NotNull KtFinallySection finallySection) {
        Intrinsics.checkNotNullParameter(finallySection, "finallySection");
        if (!this.alreadyEnteredFinallyBlock) {
            this.alreadyEnteredFinallyBlock = true;
            super.visitFinallySection(finallySection);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.stackedLabels.push(expression2.getFirstChild().getText());
        super.visitCallExpression(expression2);
        this.stackedLabels.pop();
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        int n = this.loopDepthCounter;
        this.loopDepthCounter = n + 1;
        super.visitLoopExpression(loopExpression);
        n = this.loopDepthCounter;
        this.loopDepthCounter = n + -1;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        int n = this.functionDepthCounter;
        this.functionDepthCounter = n + 1;
        super.visitNamedFunction(function2);
        n = this.functionDepthCounter;
        this.functionDepthCounter = n + -1;
    }

    @Override
    public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression2);
    }

    @Override
    public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression2);
    }

    @Override
    public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkAndVisit(this.functionDepthCounter, expression2);
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.functionDepthCounter == 0) {
            this.report.invoke(expression2);
        }
    }

    private final void checkAndVisit(int depthCounter, KtExpressionWithLabel expression2) {
        if (expression2.getLabelQualifier() != null) {
            String string2 = expression2.getLabelName();
            Intrinsics.checkNotNull(string2);
            if (!this.stackedLabels.contains(string2)) {
                this.report.invoke(expression2);
            }
        } else if (depthCounter == 0) {
            this.report.invoke(expression2);
        }
        this.visitExpressionWithLabel(expression2);
    }
}

