/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S103")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLineCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "maximumLineLength", "", "getMaximumLineLength", "()I", "setMaximumLineLength", "(I)V", "getLineRange", "Lorg/sonar/api/batch/fs/TextRange;", "kotlin.jvm.PlatformType", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "lineNumber", "line", "", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "Companion", "sonar-kotlin-plugin"})
public final class TooLongLineCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="200")
    private int maximumLineLength = 200;
    public static final int DEFAULT_MAXIMUM_LINE_LENGTH = 200;

    public final int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public final void setMaximumLineLength(int n) {
        this.maximumLineLength = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        String string2 = file2.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "file.text");
        String[] stringArray = new String[]{"\n", "\r\n", "\r"};
        Sequence $this$forEachIndexed$iv = StringsKt.splitToSequence$default((CharSequence)string2, stringArray, false, 0, 6, null);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator iterator2 = $this$forEachIndexed$iv.iterator();
        while (iterator2.hasNext()) {
            void line;
            int n;
            Object item$iv = iterator2.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string3 = (String)item$iv;
            int lineNumber = n;
            boolean bl = false;
            if (line.length() <= this.maximumLineLength) continue;
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, this.getLineRange(kotlinFileContext.getInputFileContext().getInputFile(), lineNumber, (String)line), "Split this " + line.length() + " characters long line (which is greater than " + this.maximumLineLength + " authorized).", null, null, 12, null);
        }
    }

    private final TextRange getLineRange(InputFile inputFile, int lineNumber, String line) {
        return inputFile.newRange(inputFile.newPointer(lineNumber + 1, 0), inputFile.newPointer(lineNumber + 1, line.length()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLineCheck$Companion;", "", "()V", "DEFAULT_MAXIMUM_LINE_LENGTH", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

