/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.FunMatcherKt;
import org.sonarsource.kotlin.checks.VerifiedServerHostnamesCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S5527")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "onlyReturnsTrue", "", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visitLambdaExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isTrueConstant", "Companion", "sonar-kotlin-plugin"})
public final class VerifiedServerHostnamesCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FunMatcherImpl VERIFY_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, null, null, false, null, null, null, null, Companion.VERIFY_MATCHER.1.INSTANCE, 2047, null);
    @NotNull
    private static final FunMatcherImpl HOSTNAME_VERIFIER_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, null, null, false, null, null, null, null, Companion.HOSTNAME_VERIFIER_MATCHER.1.INSTANCE, 2047, null);
    @NotNull
    public static final String MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        List<KtExpression> listStatements;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext2 = kotlinFileContext.component3();
        if (VERIFY_MATCHER.matches(function2, bindingContext2) && (listStatements = this.listStatements$sonar_kotlin_plugin(function2)).size() == 1 && this.onlyReturnsTrue(listStatements.get(0), bindingContext2)) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, psiElement, MESSAGE, null, null, 12, null);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        block3: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            BindingContext bindingContext2 = kotlinFileContext.component3();
            Call call2 = CallUtilKt.getParentCall$default(expression2, bindingContext2, false, 2, null);
            if (call2 == null) break block3;
            Call it = call2;
            boolean bl = false;
            if (HOSTNAME_VERIFIER_MATCHER.matches(it, bindingContext2)) {
                List<KtExpression> listStatements;
                KtBlockExpression ktBlockExpression = expression2.getBodyExpression();
                List<KtExpression> list2 = listStatements = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
                boolean bl2 = list2 != null ? list2.size() == 1 : false;
                if (bl2) {
                    KtExpression ktExpression = listStatements.get(0);
                    Intrinsics.checkNotNullExpressionValue(ktExpression, "listStatements[0]");
                    if (this.isTrueConstant(ktExpression, bindingContext2)) {
                        AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, expression2, MESSAGE, null, null, 12, null);
                    }
                }
            }
        }
    }

    private final boolean onlyReturnsTrue(KtExpression ktExpression, BindingContext bindingContext2) {
        boolean bl;
        if (ktExpression instanceof KtReturnExpression) {
            KtExpression ktExpression2 = ((KtReturnExpression)ktExpression).getReturnedExpression();
            bl = ktExpression2 != null ? this.isTrueConstant(ktExpression2, bindingContext2) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isTrueConstant(KtExpression $this$isTrueConstant, BindingContext bindingContext2) {
        boolean bl;
        KotlinType kotlinType = CallUtilKt.getType($this$isTrueConstant, bindingContext2);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl2 = false;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, $this$isTrueConstant);
            bl = compileTimeConstant != null ? Intrinsics.areEqual(compileTimeConstant.getValue(it), true) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck$Companion;", "", "()V", "HOSTNAME_VERIFIER_MATCHER", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getHOSTNAME_VERIFIER_MATCHER", "()Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "MESSAGE", "", "VERIFY_MATCHER", "getVERIFY_MATCHER", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FunMatcherImpl getVERIFY_MATCHER() {
            return VERIFY_MATCHER;
        }

        @NotNull
        public final FunMatcherImpl getHOSTNAME_VERIFIER_MATCHER() {
            return HOSTNAME_VERIFIER_MATCHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

