/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.sonarsource.analyzer.commons.recognizers.CodeRecognizer;
import org.sonarsource.kotlin.converter.Environment;
import org.sonarsource.kotlin.converter.KotlinCodeVerifier$parsingIsSuccessful$;
import org.sonarsource.kotlin.converter.KotlinFootprint;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/converter/KotlinCodeVerifier;", "", "()V", "KDOC_TAGS", "", "", "codeRecognizer", "Lorg/sonarsource/analyzer/commons/recognizers/CodeRecognizer;", "environment", "Lorg/sonarsource/kotlin/converter/Environment;", "containsCode", "", "content", "isInfixNotation", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isKDoc", "isNonCodeParsedAsCode", "tree", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "parsingIsSuccessful", "sonar-kotlin-plugin"})
public final class KotlinCodeVerifier {
    @NotNull
    public static final KotlinCodeVerifier INSTANCE = new KotlinCodeVerifier();
    @NotNull
    private static final Environment environment = new Environment(CollectionsKt.emptyList(), LanguageVersion.LATEST_STABLE, null, null, 12, null);
    @NotNull
    private static final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, KotlinFootprint.INSTANCE);
    @NotNull
    private static final List<String> KDOC_TAGS;

    private KotlinCodeVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsCode(@NotNull String content2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(content2, "content");
        Object object = ((Object)StringsKt.trim((CharSequence)content2)).toString();
        Regex regex = new Regex("\\w+");
        int n = 0;
        Iterable $this$filter$iv = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        int n2 = 0;
        object2 = object.iterator();
        while (object2.hasNext()) {
            void it;
            Object e = object2.next();
            String $i$f$filterTo2 = (String)e;
            int n3 = n2;
            boolean bl = false;
            int n4 = ((Object)StringsKt.trim((CharSequence)it)).toString().length();
            n2 = n3 + n4;
        }
        int words = n2;
        return words > 2 && !this.isKDoc(content2) && codeRecognizer.isLineOfCode(content2) && this.parsingIsSuccessful(content2);
    }

    private final boolean parsingIsSuccessful(String content2) {
        boolean bl;
        try {
            String wrappedContent = "fun function () { " + content2 + " }";
            KtFile ktFile = environment.getKtPsiFactory().createFile(wrappedContent);
            PsiElement $this$findDescendantOfType_u24default$iv = ktFile;
            Function1 predicate$iv = parsingIsSuccessful$$inlined$findDescendantOfType$default$1.INSTANCE;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv.element == null && !this.isNonCodeParsedAsCode(ktFile);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isKDoc(String content2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = KDOC_TAGS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string2 = content2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!StringsKt.contains$default((CharSequence)string2, it, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNonCodeParsedAsCode(PsiFile tree) {
        boolean bl;
        block1: {
            PsiElement[] elements = tree.getLastChild().getLastChild().getChildren();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(elements, "elements");
            PsiElement[] $this$all$iv = elements;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiElement element$iv;
                PsiElement it = element$iv = $this$all$iv[i];
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (INSTANCE.isInfixNotation(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixNotation(PsiElement element) {
        if (!(element instanceof KtBinaryExpression)) return false;
        PsiElement[] binaryExprChildren = element.getChildren();
        boolean bl = false;
        if (binaryExprChildren.length != 3) return false;
        if (!(binaryExprChildren[1] instanceof KtOperationReferenceExpression)) return false;
        return true;
    }

    static {
        String[] stringArray = new String[]{"@param", "@return", "@constructor", "@receiver", "@property", "@throws", "@exception", "@sample", "@see", "@author", "@since", "@suppress", "`"};
        KDOC_TAGS = CollectionsKt.listOf(stringArray);
    }
}

