/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.surefire.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonarsource.kotlin.plugin.surefire.data.UnitTestResult;

public final class UnitTestClassReport {
    private int errors = 0;
    private int failures = 0;
    private int skipped = 0;
    private int tests = 0;
    private long durationMilliseconds = 0L;
    private long negativeTimeTestNumber = 0L;
    private List<UnitTestResult> results = null;

    public UnitTestClassReport add(UnitTestClassReport other) {
        for (UnitTestResult otherResult : other.getResults()) {
            this.add(otherResult);
        }
        return this;
    }

    public UnitTestClassReport add(UnitTestResult result2) {
        this.initResults();
        boolean hasName = this.results.stream().map(UnitTestResult::getName).anyMatch(result2.getName()::equals);
        if (hasName && result2.getName().contains("$")) {
            return this;
        }
        this.results.add(result2);
        if (result2.getStatus().equals("skipped")) {
            ++this.skipped;
        } else if (result2.getStatus().equals("failure")) {
            ++this.failures;
        } else if (result2.getStatus().equals("error")) {
            ++this.errors;
        }
        ++this.tests;
        if (result2.getDurationMilliseconds() < 0L) {
            ++this.negativeTimeTestNumber;
        } else {
            this.durationMilliseconds += result2.getDurationMilliseconds();
        }
        return this;
    }

    private void initResults() {
        if (this.results == null) {
            this.results = new ArrayList<UnitTestResult>();
        }
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getTests() {
        return this.tests;
    }

    public long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public long getNegativeTimeTestNumber() {
        return this.negativeTimeTestNumber;
    }

    public List<UnitTestResult> getResults() {
        if (this.results == null) {
            return Collections.emptyList();
        }
        return this.results;
    }
}

