/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Omitting \"KmsMasterKeyId\" disables SQS queues encryption. Make sure it is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::SQS::Queue") && PropertyUtils.isMissing(resource.properties(), "KmsMasterKeyId")) {
            ctx.reportIssue(resource.type(), MESSAGE);
        }
    }
}

