/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6321")
public class UnrestrictedAdministrationCheck
extends AbstractResourceCheck {
    public static final String MESSAGE = "Restrict IP addresses authorized to access administration services";
    public static final int SSH_PORT = 22;
    public static final int RDP_PORT = 3389;

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::EC2::SecurityGroup")) {
            UnrestrictedAdministrationCheck.checkSecurityGroup(ctx, resource);
        }
    }

    private static void checkSecurityGroup(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value(resource.properties(), "SecurityGroupIngress", SequenceTree.class).ifPresent(sequenceTree -> sequenceTree.elements().forEach(r -> UnrestrictedAdministrationCheck.checkIngressRule(ctx, r)));
    }

    private static void checkIngressRule(CheckContext ctx, Tree rule) {
        Optional<Tree> defaultRouteCidrTree = UnrestrictedAdministrationCheck.getDefaultRouteCidr(rule);
        if (!defaultRouteCidrTree.isPresent()) {
            return;
        }
        Optional<Tree> ipProtocol = PropertyUtils.value(rule, "IpProtocol");
        if (ipProtocol.isPresent() && TextUtils.isValue(ipProtocol.get(), "-1").isTrue()) {
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree.get(), MESSAGE, new SecondaryLocation(ipProtocol.get(), "Related protocol setting"));
        } else if (ipProtocol.isPresent() && TextUtils.isValue(ipProtocol.get(), "tcp").isTrue()) {
            UnrestrictedAdministrationCheck.checkTcpPorts(ctx, rule, defaultRouteCidrTree.get(), ipProtocol.get());
        }
    }

    private static Optional<Tree> getDefaultRouteCidr(Tree rule) {
        Optional<Tree> optCidrIp = PropertyUtils.value(rule, "CidrIp").filter(c -> TextUtils.isValue(c, "0.0.0.0/0").isTrue());
        Optional<Tree> optCidrIpv6 = PropertyUtils.value(rule, "CidrIpv6").filter(c -> TextUtils.isValue(c, "::/0").isTrue());
        return optCidrIp.isPresent() ? optCidrIp : optCidrIpv6;
    }

    private static void checkTcpPorts(CheckContext ctx, Tree rule, Tree defaultRouteCidrTree, Tree ipProtocol) {
        Optional<Tree> fromPort = PropertyUtils.value(rule, "FromPort");
        Optional<Tree> toPort = PropertyUtils.value(rule, "ToPort");
        if (fromPort.isPresent() && toPort.isPresent() && UnrestrictedAdministrationCheck.rangeContainsSshOrRdpPorts(fromPort.get(), toPort.get())) {
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            secondaryLocations.add(new SecondaryLocation(ipProtocol, "Related protocol setting"));
            secondaryLocations.add(new SecondaryLocation(fromPort.get(), "Port range start"));
            secondaryLocations.add(new SecondaryLocation(toPort.get(), "Port range end"));
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree, MESSAGE, secondaryLocations);
        }
    }

    private static boolean rangeContainsSshOrRdpPorts(Tree from, Tree to) {
        Optional<Integer> fromIntValue = TextUtils.getIntValue(from);
        Optional<Integer> toIntValue = TextUtils.getIntValue(to);
        return fromIntValue.isPresent() && toIntValue.isPresent() && (22 >= fromIntValue.get() && 22 <= toIntValue.get() || 3389 >= fromIntValue.get() && 3389 <= toIntValue.get());
    }
}

