/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class XPathUtils {
    private final List<YamlTree> result = new ArrayList<YamlTree>();

    private XPathUtils() {
    }

    public static Optional<YamlTree> getSingleTree(YamlTree root, String expression) {
        List<YamlTree> trees = XPathUtils.getTrees(root, expression);
        if (trees.size() == 1) {
            return Optional.of(trees.get(0));
        }
        return Optional.empty();
    }

    public static List<YamlTree> getTrees(YamlTree root, String expression) {
        if (!expression.startsWith("/")) {
            throw new InvalidXPathExpression("For now all paths have to start with slash");
        }
        XPathUtils utils = new XPathUtils();
        utils.visitTree(root, new StringTokenizer(expression, "/"));
        return utils.result;
    }

    void visitTree(YamlTree tree, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreTokens()) {
            this.result.add(tree);
            return;
        }
        this.visitTree(tree, tokenizer, tokenizer.nextToken());
    }

    void visitTree(YamlTree tree, StringTokenizer tokenizer, String token) {
        boolean expectSequence = false;
        if (token.endsWith("[]")) {
            expectSequence = true;
            token = token.substring(0, token.length() - 2);
        }
        if (tree instanceof MappingTree) {
            String finalToken = token;
            Stream<TupleTree> tuples = ((MappingTree)tree).elements().stream().filter(t -> TextUtils.isValue(t.key(), finalToken).isTrue());
            if (expectSequence) {
                tuples.map(TupleTree::value).filter(SequenceTree.class::isInstance).forEach(t -> {
                    if (!tokenizer.hasMoreTokens()) {
                        this.result.addAll(((SequenceTree)t).elements());
                    } else {
                        String nextToken = tokenizer.nextToken();
                        ((SequenceTree)t).elements().forEach(e -> this.visitTree((YamlTree)e, tokenizer, nextToken));
                    }
                });
            } else {
                tuples.forEach(t -> this.visitTree(t.value(), tokenizer));
            }
        }
    }

    static class InvalidXPathExpression
    extends RuntimeException {
        public InvalidXPathExpression(String message) {
            super(message);
        }
    }
}

