/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.sonar.iac.cloudformation.tree.FunctionCallTree;
import org.sonar.iac.cloudformation.tree.FunctionCallTreeImpl;
import org.sonar.iac.common.yaml.YamlConverter;
import org.sonar.iac.common.yaml.tree.MappingTreeImpl;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.ScalarTreeImpl;
import org.sonar.iac.common.yaml.tree.SequenceTreeImpl;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;

public class CloudformationConverter
extends YamlConverter {
    @Override
    protected YamlTree convertMapping(MappingNode mappingNode) {
        NodeTuple functionCallNode;
        FunctionCallTreeImpl functionCall;
        ArrayList<TupleTree> elements = new ArrayList<TupleTree>();
        if (mappingNode.getValue().size() == 1 && mappingNode.getValue().get(0).getKeyNode() instanceof ScalarNode && (functionCall = this.convertTupleToFunctionCall((ScalarNode)(functionCallNode = mappingNode.getValue().get(0)).getKeyNode(), functionCallNode.getValueNode())) != null) {
            return functionCall;
        }
        for (NodeTuple elementNode : mappingNode.getValue()) {
            elements.add(this.convertTuple(elementNode));
        }
        return new MappingTreeImpl(elements, YamlTreeMetadata.fromNode(mappingNode));
    }

    @Nullable
    private FunctionCallTreeImpl convertTupleToFunctionCall(ScalarNode functionNameNode, Node argumentList) {
        return CloudformationConverter.fullStyleFunctionName(functionNameNode.getValue()).map(functionName -> {
            ArrayList<YamlTree> arguments = new ArrayList<YamlTree>();
            if (argumentList instanceof SequenceNode) {
                for (Node elementNode : ((SequenceNode)argumentList).getValue()) {
                    arguments.add(this.convert(elementNode));
                }
            } else {
                arguments.add(this.convert(argumentList));
            }
            return new FunctionCallTreeImpl((String)functionName, FunctionCallTree.Style.FULL, (List<YamlTree>)arguments, YamlTreeMetadata.fromNodes("FUNCTION_CALL", functionNameNode, argumentList));
        }).orElse(null);
    }

    @Override
    protected YamlTree convertScalar(ScalarNode scalarNode) {
        FunctionCallTree functionCallFromScalar = CloudformationConverter.convertScalarToFunctionCall(scalarNode);
        if (functionCallFromScalar != null) {
            return functionCallFromScalar;
        }
        return new ScalarTreeImpl(scalarNode.getValue(), CloudformationConverter.scalarStyleConvert(scalarNode.getScalarStyle()), YamlTreeMetadata.fromNode(scalarNode));
    }

    @Override
    protected YamlTree convertSequence(SequenceNode sequenceNode) {
        ArrayList<YamlTree> elements = new ArrayList<YamlTree>();
        for (Node elementNode : sequenceNode.getValue()) {
            elements.add(this.convert(elementNode));
        }
        FunctionCallTree functionCallFromScalar = CloudformationConverter.convertSequenceToFunctionCall(sequenceNode, elements);
        if (functionCallFromScalar != null) {
            return functionCallFromScalar;
        }
        return new SequenceTreeImpl(elements, YamlTreeMetadata.fromNode(sequenceNode));
    }

    @Nullable
    private static FunctionCallTree convertSequenceToFunctionCall(SequenceNode functionNode, List<YamlTree> arguments) {
        return CloudformationConverter.shortStyleFunctionName(functionNode).map(functionName -> new FunctionCallTreeImpl((String)functionName, FunctionCallTree.Style.SHORT, arguments, YamlTreeMetadata.fromNode("FUNCTION_CALL", functionNode))).orElse(null);
    }

    @Nullable
    private static FunctionCallTree convertScalarToFunctionCall(ScalarNode scalarNode) {
        return CloudformationConverter.shortStyleFunctionName(scalarNode).map(functionName -> {
            ScalarTreeImpl argument = new ScalarTreeImpl(scalarNode.getValue(), ScalarTree.Style.OTHER, YamlTreeMetadata.fromNode(Tag.STR.getValue(), scalarNode));
            return new FunctionCallTreeImpl((String)functionName, FunctionCallTree.Style.SHORT, List.of(argument), YamlTreeMetadata.fromNode("FUNCTION_CALL", scalarNode));
        }).orElse(null);
    }

    private static Optional<String> shortStyleFunctionName(Node functionNode) {
        String tag = YamlTreeMetadata.tag(functionNode);
        if (tag.startsWith("!")) {
            return Optional.of(tag.substring(1));
        }
        return Optional.empty();
    }

    private static Optional<String> fullStyleFunctionName(String value) {
        if (value.startsWith("Fn::")) {
            return Optional.of(value.substring(4));
        }
        if (value.equals("Ref")) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

