/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

public final class ResourceAccessPolicyVector {
    private static final Logger LOG = Loggers.get(ResourceAccessPolicyVector.class);
    private static final String VECTOR_FILE = "ResourceAccessPolicyVector.json";
    private static final List<String> RESOURCE_ACCESS_POLICIES = ResourceAccessPolicyVector.loadResourceAccessPolicies();

    private ResourceAccessPolicyVector() {
    }

    private static List<String> loadResourceAccessPolicies() {
        try {
            String resourceAccessPolicies = ResourceAccessPolicyVector.loadJsonFile(VECTOR_FILE);
            JSONParser parser = new JSONParser();
            return (JSONArray)parser.parse(resourceAccessPolicies);
        }
        catch (IOException | ParseException e) {
            LOG.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    static String loadJsonFile(String filePath) throws IOException {
        try (InputStream input = ResourceAccessPolicyVector.class.getClassLoader().getResourceAsStream(filePath);){
            if (input == null) {
                throw new IOException("No able to load " + filePath);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = input.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = input.read(buffer);
            }
            String string = out.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public static boolean isResourceAccessPolicy(Tree action) {
        return TextUtils.matchesValue(action, RESOURCE_ACCESS_POLICIES::contains).isTrue();
    }
}

