/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.tree.api.AliasTree;
import org.sonar.iac.docker.tree.api.FromTree;
import org.sonar.iac.docker.tree.api.InstructionTree;
import org.sonar.iac.docker.tree.api.SyntaxToken;

@Rule(key="S6476")
public class InstructionFormatCheck
implements IacCheck {
    private static final String MESSAGE = "Replace `%s` with upper case format `%s`.";
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("[a-z]");

    @Override
    public void initialize(InitContext init) {
        init.register(InstructionTree.class, (ctx, instruction) -> InstructionFormatCheck.checkInstructionKeyword(ctx, instruction.keyword()));
        init.register(FromTree.class, (ctx, from) -> {
            AliasTree alias = from.alias();
            if (alias != null) {
                InstructionFormatCheck.checkInstructionKeyword(ctx, alias.keyword());
            }
        });
    }

    private static void checkInstructionKeyword(CheckContext ctx, SyntaxToken keyword) {
        String value = keyword.value();
        if (KEYWORD_PATTERN.matcher(value).find()) {
            ctx.reportIssue(keyword, String.format(MESSAGE, value, value.toUpperCase(Locale.ROOT)));
        }
    }
}

