/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser.grammar;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import org.sonar.iac.common.parser.grammar.Punctuator;
import org.sonar.iac.docker.parser.grammar.DockerKeyword;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum DockerLexicalGrammar implements GrammarRuleKey
{
    FILE,
    DOCKERIMAGE,
    STRING_LITERAL,
    KEY_IN_KEY_VALUE_PAIR_IN_EQUALS_SYNTAX,
    VALUE_IN_KEY_VALUE_PAIR_IN_EQUALS_SYNTAX,
    STRING_UNTIL_EOL,
    STRING_LITERAL_WITH_QUOTES,
    EQUALS_OPERATOR,
    EOF,
    SPACING,
    INSTRUCTION_PREFIX,
    WHITESPACE_OR_ESCAPED_LINE_BREAK,
    WHITESPACE_OR_LINE_BREAK,
    INSTRUCTION,
    ONBUILD,
    FROM,
    MAINTAINER,
    STOPSIGNAL,
    WORKDIR,
    EXPOSE,
    LABEL,
    ENV,
    ARG,
    CMD,
    ENTRYPOINT,
    RUN,
    ADD,
    COPY,
    USER,
    VOLUME,
    SHELL,
    HEALTHCHECK,
    NONE,
    ARGUMENTS,
    PORT,
    KEY_ONLY,
    KEY_VALUE_PAIR_EQUALS,
    KEY_VALUE_PAIR_SINGLE,
    PARAM,
    PARAM_NO_VALUE,
    PARAM_PREFIX,
    PARAM_NAME,
    PARAM_VALUE,
    ARG_NAME,
    EXEC_FORM,
    SHELL_FORM,
    HEREDOC_FORM,
    IMAGE,
    ALIAS,
    IMAGE_ALIAS,
    IMAGE_NAME,
    IMAGE_TAG,
    IMAGE_DIGEST,
    USER_STRING,
    USER_VARIABLE,
    USER_NAME,
    USER_SEPARATOR,
    USER_GROUP,
    EXPOSE_PORT,
    EXPOSE_SEPARATOR_PORT,
    EXPOSE_SEPARATOR_PROTOCOL,
    EXPOSE_PROTOCOL,
    HEREDOC_EXPRESSION;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        DockerLexicalGrammar.lexical(b);
        DockerLexicalGrammar.punctuators(b);
        DockerLexicalGrammar.keywords(b);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        for (Punctuator p : Punctuator.values()) {
            b.rule(p).is(SPACING, p.getValue()).skip();
        }
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(WHITESPACE_OR_ESCAPED_LINE_BREAK).is(b.skippedTrivia(b.regexp("(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]|(?:\\\\[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029])))*+")));
        b.rule(WHITESPACE_OR_LINE_BREAK).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")));
        b.rule(SPACING).is(WHITESPACE_OR_ESCAPED_LINE_BREAK, b.zeroOrMore(b.commentTrivia(b.regexp("(?:#(?:[^\\n\\r])*+)")), b.regexp("(?:\\r\\n|[\\n\\r\\u2028\\u2029])"), WHITESPACE_OR_ESCAPED_LINE_BREAK)).skip();
        b.rule(INSTRUCTION_PREFIX).is(WHITESPACE_OR_LINE_BREAK, b.zeroOrMore(b.commentTrivia(b.regexp("(?:#(?:[^\\n\\r])*+)")), WHITESPACE_OR_LINE_BREAK)).skip();
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(STRING_LITERAL).is(SPACING, b.regexp("(?:\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\")|(?:(?:(?!(?:\\\\[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029])))[^\\s])++)"));
        b.rule(STRING_UNTIL_EOL).is(SPACING, b.regexp(".+"));
        b.rule(STRING_LITERAL_WITH_QUOTES).is(SPACING, b.regexp("\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\""));
        b.rule(EQUALS_OPERATOR).is(b.regexp("="));
        b.rule(KEY_IN_KEY_VALUE_PAIR_IN_EQUALS_SYNTAX).is(SPACING, b.regexp("(?:\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\")|(?:[^\\s=]++)"));
        b.rule(VALUE_IN_KEY_VALUE_PAIR_IN_EQUALS_SYNTAX).is(b.regexp("(?:\"[^\"]*\"|[^\\s])+"));
        b.rule(EXPOSE_PORT).is(SPACING, b.regexp("[0-9]+"));
        b.rule(EXPOSE_SEPARATOR_PORT).is(b.regexp("-"));
        b.rule(EXPOSE_SEPARATOR_PROTOCOL).is(b.regexp("/"));
        b.rule(EXPOSE_PROTOCOL).is(b.regexp("[a-zA-Z]+"));
        b.rule(IMAGE_NAME).is(SPACING, b.regexp("[^@:\\s-][^@:\\s\\$]+"));
        b.rule(IMAGE_TAG).is(b.regexp(":[^@\\s]+"));
        b.rule(IMAGE_DIGEST).is(b.regexp("@[a-zA-Z0-9:]+"));
        b.rule(IMAGE_ALIAS).is(SPACING, b.regexp("[-a-zA-Z0-9_\\.]+"));
        b.rule(PARAM_PREFIX).is(SPACING, b.regexp("--"));
        b.rule(PARAM_NAME).is(b.regexp("[a-z][-a-z]*+"));
        b.rule(PARAM_VALUE).is(b.regexp("[^\\s]+"));
        b.rule(USER_STRING).is(b.regexp("(?:[^:\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}])++"));
        b.rule(USER_VARIABLE).is(b.regexp("\\$(?:[a-zA-Z_][a-zA-Z0-9_]*|\\{[^}]+\\})"));
        b.rule(USER_NAME).is(SPACING, b.firstOf(USER_STRING, USER_VARIABLE));
        b.rule(USER_SEPARATOR).is(b.regexp(":"));
        b.rule(USER_GROUP).is(b.firstOf(USER_STRING, USER_VARIABLE));
        b.rule(HEREDOC_EXPRESSION).is(SPACING, b.regexp("(?:<<-?\"?([a-zA-Z_][a-zA-Z0-9_]*+)\"?\\s+)+[\\s\\S]*?([\\n\\r])\\1(?:[\\n\\r]|$)"));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Arrays.stream(DockerKeyword.values()).forEach(tokenType -> b.rule((GrammarRuleKey)tokenType).is(SPACING, b.regexp("(?i)" + tokenType.getValue()), b.regexp("(?=[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}\\\\]|$)")).skip());
    }
}

