/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import java.util.ArrayList;
import java.util.Optional;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.PrefixExpressionTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.IpRestrictedAdminAccessCheck;

public class AwsIpRestrictedAdminAccessCheckPart
extends AbstractResourceCheck {
    @Override
    protected void registerResourceChecks() {
        this.register(AwsIpRestrictedAdminAccessCheckPart::checkSecurityGroup, "aws_security_group");
    }

    private static void checkSecurityGroup(CheckContext ctx, BlockTree resource) {
        PropertyUtils.getAll(resource, "ingress", BlockTree.class).forEach(i -> AwsIpRestrictedAdminAccessCheckPart.checkIngress(ctx, i));
    }

    private static void checkIngress(CheckContext ctx, BlockTree ingress) {
        Optional<TupleTree> defaultRouteCidrTree = AwsIpRestrictedAdminAccessCheckPart.getDefaultRouteCidr(ingress);
        if (defaultRouteCidrTree.isEmpty()) {
            return;
        }
        Optional<Tree> ipProtocol = PropertyUtils.value((Tree)ingress, "protocol");
        if (ipProtocol.isPresent() && AwsIpRestrictedAdminAccessCheckPart.isAllProtocols(ipProtocol.get())) {
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree.get(), "Restrict IP addresses authorized to access administration services.", new SecondaryLocation(ipProtocol.get(), "Related protocol setting."));
        } else if (ipProtocol.isPresent() && TextUtils.isValue(ipProtocol.get(), "tcp").isTrue()) {
            AwsIpRestrictedAdminAccessCheckPart.checkTcpPorts(ctx, ingress, defaultRouteCidrTree.get(), ipProtocol.get());
        }
    }

    private static void checkTcpPorts(CheckContext ctx, Tree rule, Tree defaultRouteCidrTree, Tree ipProtocol) {
        Optional<Tree> fromPort = PropertyUtils.value(rule, "from_port");
        Optional<Tree> toPort = PropertyUtils.value(rule, "to_port");
        if (fromPort.isPresent() && toPort.isPresent() && AwsIpRestrictedAdminAccessCheckPart.rangeContainsSensitivePort(fromPort.get(), toPort.get())) {
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            secondaryLocations.add(new SecondaryLocation(ipProtocol, "Related protocol setting."));
            secondaryLocations.add(new SecondaryLocation(fromPort.get(), "Port range start."));
            secondaryLocations.add(new SecondaryLocation(toPort.get(), "Port range end."));
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree, "Restrict IP addresses authorized to access administration services.", secondaryLocations);
        }
    }

    private static boolean isAllProtocols(Tree tree) {
        return tree instanceof PrefixExpressionTree && "-".equals(((PrefixExpressionTree)tree).prefix().value()) && TextUtils.isValue(((PrefixExpressionTree)tree).expression(), "1").isTrue();
    }

    private static boolean rangeContainsSensitivePort(Tree from, Tree to) {
        Optional<Integer> fromIntValue = TextUtils.getIntValue(from);
        Optional<Integer> toIntValue = TextUtils.getIntValue(to);
        return fromIntValue.isPresent() && toIntValue.isPresent() && (fromIntValue.get() == 0 && toIntValue.get() == 0 || IpRestrictedAdminAccessCheck.rangeContainsSshOrRdpPort(fromIntValue.get(), toIntValue.get()));
    }

    private static Optional<TupleTree> getDefaultRouteCidr(BlockTree ingress) {
        Optional<TupleTree> optCidrIp = PropertyUtils.value(ingress, "cidr_blocks", TupleTree.class).filter(c -> AwsIpRestrictedAdminAccessCheckPart.containsValue(c, "0.0.0.0/0"));
        Optional<TupleTree> optCidrIpv6 = PropertyUtils.value(ingress, "ipv6_cidr_blocks", TupleTree.class).filter(c -> AwsIpRestrictedAdminAccessCheckPart.containsValue(c, "::/0"));
        return optCidrIp.isPresent() ? optCidrIp : optCidrIpv6;
    }

    private static boolean containsValue(TupleTree tupleTree, String value) {
        return tupleTree.elements().trees().stream().anyMatch(t -> TextUtils.isValue(t, value).isTrue());
    }
}

