/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6407")
public class AppEngineHandlerCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure creating a App Engine handler without requiring TLS is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting security_level allows unencrypted connections to the App Engine. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_app_engine_standard_app_version", "google_app_engine_flexible_app_version"), (ResourceSymbol resource) -> resource.blocks("handlers").forEach(handlers -> handlers.attribute("security_level").reportIf(ExpressionPredicate.equalTo("SECURE_OPTIONAL").or(ExpressionPredicate.equalTo("SECURE_NEVER")).or(ExpressionPredicate.equalTo("SECURE_DEFAULT")), MESSAGE, new SecondaryLocation[0]).reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0])));
    }
}

