/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.utils;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

public interface PredicateUtils {
    public static Predicate<String> exactMatchStringPredicate(String regex) {
        return PredicateUtils.exactMatchStringPredicate(regex, 0);
    }

    public static Predicate<String> exactMatchStringPredicate(String regex, int flags) {
        Pattern compiledPattern = Pattern.compile(regex, flags);
        return s -> compiledPattern.matcher((CharSequence)s).matches();
    }

    public static Predicate<String> containsMatchStringPredicate(String regex) {
        return PredicateUtils.containsMatchStringPredicate(regex, 0);
    }

    public static Predicate<String> containsMatchStringPredicate(String regex, int flags) {
        Pattern compiledPattern = Pattern.compile(regex, flags);
        return s -> compiledPattern.matcher((CharSequence)s).find();
    }

    public static <T extends Tree> Predicate<T> treePredicate(Predicate<String> stringPredicate) {
        return tree -> TextUtils.matchesValue(tree, stringPredicate).isTrue();
    }
}

