/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.plugin;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ScannerSide
public class TerraformProviders {
    private static final String MISSING_PROVIDER_VERSION = "Provide the used %s provider version via the \"%s\" property to increase the accuracy of your results.";
    private static final String INVALID_PROVIDER_VERSION = "Can not parse provider version for \"%s\". Please check the format of your used %s version in the project settings.";
    private static final Logger LOG = Loggers.get(TerraformProviders.class);
    private static final Provider UNKNOWN_PROVIDER = new Provider(null);
    private final EnumMap<Provider.Identifier, Provider> providers = new EnumMap(Provider.Identifier.class);
    private final AnalysisWarnings analysisWarnings;
    private final EnumSet<Provider.Identifier> raisedWarnings = EnumSet.noneOf(Provider.Identifier.class);

    public TerraformProviders(SensorContext sensorContext, AnalysisWarnings analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
        for (Provider.Identifier identifier : Provider.Identifier.values()) {
            sensorContext.config().get(identifier.key).flatMap(version -> this.parseProviderVersion(identifier, (String)version)).map(Provider::new).ifPresent(provider -> this.providers.put(identifier, (Provider)provider));
        }
    }

    private Optional<Version> parseProviderVersion(Provider.Identifier identifier, String version) {
        if (version.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Version.parse((String)version));
        }
        catch (IllegalArgumentException e) {
            this.raiseWarning(identifier, String.format(INVALID_PROVIDER_VERSION, identifier.key, identifier.name));
            LOG.warn("Can not parse provider version \"{}\". Input: \"{}\"", (Object)identifier.key, (Object)version);
            return Optional.empty();
        }
    }

    private void raiseWarning(Provider.Identifier identifier, String text) {
        if (this.raisedWarnings.add(identifier)) {
            this.analysisWarnings.addUnique(text);
        }
    }

    public Provider provider(Provider.Identifier identifier) {
        if (this.providers.containsKey((Object)identifier)) {
            return this.providers.get((Object)identifier);
        }
        this.raiseWarning(identifier, String.format(MISSING_PROVIDER_VERSION, identifier.name, identifier.key));
        return UNKNOWN_PROVIDER;
    }

    public static final class Provider {
        final Version providerVersion;

        public Provider(@Nullable Version providerVersion) {
            this.providerVersion = providerVersion;
        }

        public boolean hasVersionLowerThan(Version version) {
            if (this.providerVersion == null) {
                return false;
            }
            return this.providerVersion.compareTo(version) < 0;
        }

        public static enum Identifier {
            AWS("sonar.terraform.provider.aws.version", "AWS"),
            AZURE("sonar.terraform.provider.azure.version", "Azure");

            public final String key;
            private final String name;

            private Identifier(String key, String name) {
                this.key = key;
                this.name = name;
            }
        }
    }
}

