/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.utils.TerraformUtils;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.Symbol;

public class ReferenceSymbol
extends Symbol<AttributeTree> {
    private AttributeAccessTree reference;

    private ReferenceSymbol(CheckContext ctx, AttributeTree tree, String name, BlockSymbol parent, AttributeAccessTree reference) {
        super(ctx, tree, name, parent);
        if (reference != null) {
            this.reference = reference;
        }
    }

    public static ReferenceSymbol fromPresent(CheckContext ctx, AttributeTree tree, BlockSymbol parent) {
        if (tree.value().is(TerraformTree.Kind.ATTRIBUTE_ACCESS)) {
            return new ReferenceSymbol(ctx, tree, tree.key().value(), parent, (AttributeAccessTree)tree.value());
        }
        return ReferenceSymbol.fromAbsent(ctx, tree.key().value(), parent);
    }

    public static ReferenceSymbol fromAbsent(CheckContext ctx, String name, BlockSymbol parent) {
        return new ReferenceSymbol(ctx, null, name, parent, null);
    }

    public BlockSymbol resolve(Map<String, BlockSymbol> symbolTable) {
        return Optional.ofNullable((AttributeTree)this.tree).map(tree -> (BlockSymbol)symbolTable.get(TerraformUtils.attributeAccessToString(this.reference))).orElse(BlockSymbol.fromAbsent(this.ctx, "unknown", null));
    }

    @Override
    @Nullable
    protected HasTextRange toHighlight() {
        return this.tree;
    }
}

