/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.ForObjectTree;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.parser.TreeFactory;
import org.sonar.iac.terraform.tree.impl.AbstractForTree;

public class ForObjectTreeImpl
extends AbstractForTree
implements ForObjectTree {
    private final SyntaxToken openBrace;
    private final ExpressionTree firstExpression;
    private final SyntaxToken arrow;
    private final ExpressionTree secondExpression;
    private final SyntaxToken ellipsis;
    private final TreeFactory.Pair<SyntaxToken, ExpressionTree> condition;
    private final SyntaxToken closeBrace;

    public ForObjectTreeImpl(SyntaxToken openBrace, AbstractForTree.ForIntro intro, ExpressionTree firstExpression, SyntaxToken arrow, ExpressionTree secondExpression, @Nullable SyntaxToken ellipsis, @Nullable TreeFactory.Pair<SyntaxToken, ExpressionTree> condition, SyntaxToken closeBrace) {
        super(intro);
        this.openBrace = openBrace;
        this.firstExpression = firstExpression;
        this.arrow = arrow;
        this.secondExpression = secondExpression;
        this.ellipsis = ellipsis;
        this.condition = condition;
        this.closeBrace = closeBrace;
    }

    @Override
    public ExpressionTree firstExpression() {
        return this.firstExpression;
    }

    @Override
    public ExpressionTree secondExpression() {
        return this.secondExpression;
    }

    @Override
    public boolean hasEllipsis() {
        return this.ellipsis != null;
    }

    @Override
    public Optional<ExpressionTree> condition() {
        return this.condition != null ? Optional.of(this.condition.second()) : Optional.empty();
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.FOR_OBJECT;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.openBrace);
        children.addAll(this.intro.children());
        children.add(this.firstExpression);
        children.add(this.arrow);
        children.add(this.secondExpression);
        if (this.ellipsis != null) {
            children.add(this.ellipsis);
        }
        if (this.condition != null) {
            children.add(this.condition.first());
            children.add(this.condition.second());
        }
        children.add(this.closeBrace);
        return children;
    }
}

