/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class ZeroOrMoreExpression
implements ParsingExpression {
    private final ParsingExpression subExpression;

    public ZeroOrMoreExpression(ParsingExpression subExpression) {
        this.subExpression = subExpression;
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        Instruction[] sub = compiler.compile(this.subExpression);
        Instruction[] result = new Instruction[sub.length + 2];
        result[0] = Instruction.choice(sub.length + 2);
        System.arraycopy(sub, 0, result, 1, sub.length);
        result[sub.length + 1] = Instruction.commitVerify(-1 - sub.length);
        return result;
    }

    public String toString() {
        return "ZeroOrMore[" + this.subExpression + "]";
    }
}

