/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.common.BinaryFileUtils;

public class InputFileContext {
    private static final char LINE_FEED = '\n';
    private final SensorContext sensorContext;
    private final InputFile inputFile;
    private final boolean hasNonTextCharacters;
    private final List<String> lines;
    private final String normalizedContent;
    private final Set<String> raisedIssues = new HashSet<String>();

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) throws IOException {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
        boolean checkNonTextCharacters = inputFile.language() == null;
        ArrayList<String> contentLines = new ArrayList<String>();
        try (InputStream in = inputFile.inputStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, inputFile.charset()));
            String line = reader.readLine();
            while (line != null) {
                if (checkNonTextCharacters && BinaryFileUtils.hasNonTextCharacters(line)) {
                    this.hasNonTextCharacters = true;
                    this.lines = Collections.emptyList();
                    this.normalizedContent = "";
                    return;
                }
                contentLines.add(line);
                line = reader.readLine();
            }
        }
        this.hasNonTextCharacters = false;
        this.lines = contentLines;
        this.normalizedContent = String.join((CharSequence)"\n", contentLines);
    }

    public boolean hasNonTextCharacters() {
        return this.hasNonTextCharacters;
    }

    public String content() {
        return this.normalizedContent;
    }

    public List<String> lines() {
        return this.lines;
    }

    public String toString() {
        return this.inputFile.toString();
    }

    public void reportIssue(RuleKey ruleKey, int line, String message) {
        if (this.raisedIssues.add(ruleKey + ":" + line)) {
            NewIssue issue = this.sensorContext.newIssue();
            issue.forRule(ruleKey).at(issue.newLocation().on((InputComponent)this.inputFile).at(this.inputFile.selectLine(line)).message(message)).save();
        }
    }

    public void reportIssue(RuleKey ruleKey, TextRange textRange, String message) {
        NewIssue issue = this.sensorContext.newIssue();
        issue.forRule(ruleKey).at(issue.newLocation().on((InputComponent)this.inputFile).at(textRange).message(message)).save();
    }

    public TextRange newTextRangeFromFileOffsets(int startOffset, int endOffset) {
        int charOffset;
        int lineNumber = 1;
        TextPointer startPointer = null;
        int currentLineStartOffset = 0;
        for (charOffset = 0; charOffset < this.normalizedContent.length(); ++charOffset) {
            if (charOffset == startOffset) {
                startPointer = this.inputFile.newPointer(lineNumber, startOffset - currentLineStartOffset);
            }
            if (charOffset == endOffset) {
                TextPointer endPointer = this.inputFile.newPointer(lineNumber, endOffset - currentLineStartOffset);
                return this.inputFile.newRange(Objects.requireNonNull(startPointer), endPointer);
            }
            if (this.normalizedContent.charAt(charOffset) != '\n') continue;
            ++lineNumber;
            currentLineStartOffset = charOffset + 1;
        }
        if (startPointer != null && charOffset == endOffset) {
            TextPointer endPointer = this.inputFile.newPointer(lineNumber, endOffset - currentLineStartOffset);
            return this.inputFile.newRange(Objects.requireNonNull(startPointer), endPointer);
        }
        throw new IllegalStateException("Invalid offsets: startOffset=" + startOffset + ", endOffset=" + endOffset);
    }
}

