/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.HashMap;

public final class EntropyChecker {
    public static final double ENTROPY_THRESHOLD = 4.2;

    private EntropyChecker() {
    }

    public static boolean hasLowEntropy(String str) {
        return EntropyChecker.calculateShannonEntropy(str) < 4.2;
    }

    public static double calculateShannonEntropy(String str) {
        if (str.isEmpty()) {
            return 0.0;
        }
        HashMap<Character, Integer> charMap = new HashMap<Character, Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            charMap.putIfAbsent(Character.valueOf(c), 0);
            charMap.put(Character.valueOf(c), (Integer)charMap.get(Character.valueOf(c)) + 1);
        }
        double entropy = 0.0;
        for (Integer count : charMap.values()) {
            double frequency = 1.0 * (double)count.intValue() / (double)str.length();
            entropy -= frequency * Math.log(frequency) / Math.log(2.0);
        }
        return entropy;
    }
}

