/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.secrets.api.EntropyChecker;
import org.sonar.plugins.secrets.api.RegexMatcher;
import org.sonar.plugins.secrets.api.SecretCheck;
import org.sonar.plugins.secrets.api.SecretRule;

@Rule(key="S6336")
public class AlibabaCloudAccessKeyCheck
extends SecretCheck {
    public AlibabaCloudAccessKeyCheck() {
        super(new SecretRule("Make sure this Alibaba Cloud Access Key ID is not disclosed.", new RegexMatcher("\\b(LTAI[0-9A-Za-z]{12}(:?[0-9A-Za-z]{8})?)\\b")), new SecretRule("Make sure this Alibaba Cloud Access Key Secret is not disclosed.", EntropyChecker::hasLowEntropy, new RegexMatcher("(?i)(?<![A-Z])ali(?:yun|baba|cloud).{0,50}['\"`]([0-9a-z]{30})['\"`]"), new RegexMatcher("(?i)(?:SECRET_?(?:ACCESS)?_?KEY|(?:ACCESS)?_?KEY_?SECRET)\\b[^0-9a-z]{0,10}([0-9a-z]{30})(?![a-z0-9\\/+=$\\-_])")));
    }
}

