/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S108")
public class EmptyBlockCheck
implements SlangCheck {
    private static final String MESSAGE = "Either remove or fill this block of code.";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, blockTree) -> {
            Tree parent = ctx.parent();
            if (EmptyBlockCheck.isValidBlock(parent) && blockTree.statementOrExpressions().isEmpty()) {
                EmptyBlockCheck.checkComments(ctx, blockTree);
            }
        });
        init.register(MatchTree.class, (ctx, matchTree) -> {
            if (matchTree.cases().isEmpty()) {
                EmptyBlockCheck.checkComments(ctx, matchTree);
            }
        });
    }

    private static boolean isValidBlock(@Nullable Tree parent) {
        return !(parent instanceof FunctionDeclarationTree) && !(parent instanceof NativeTree) && !EmptyBlockCheck.isWhileLoop(parent);
    }

    private static boolean isWhileLoop(@Nullable Tree parent) {
        return parent instanceof LoopTree && ((LoopTree)parent).kind() == LoopTree.LoopKind.WHILE;
    }

    private static void checkComments(CheckContext ctx, Tree tree) {
        if (tree.metaData().commentsInside().isEmpty()) {
            ctx.reportIssue(tree, MESSAGE);
        }
    }
}

