/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1172")
public class UnusedFunctionParameterCheck
implements SlangCheck {
    protected static final Pattern IGNORED_PATTERN = Pattern.compile("main", 2);

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, functionDeclarationTree) -> {
            if (functionDeclarationTree.isConstructor() || this.shouldBeIgnored((CheckContext)ctx, (FunctionDeclarationTree)functionDeclarationTree)) {
                return;
            }
            List<ParameterTree> unusedParameters = UnusedFunctionParameterCheck.getUnusedParameters(functionDeclarationTree);
            if (unusedParameters.isEmpty()) {
                return;
            }
            this.reportUnusedParameters((CheckContext)ctx, unusedParameters);
        });
    }

    protected static List<ParameterTree> getUnusedParameters(FunctionDeclarationTree functionDeclarationTree) {
        return functionDeclarationTree.formalParameters().stream().filter(ParameterTree.class::isInstance).map(ParameterTree.class::cast).filter(parameterTree -> parameterTree.modifiers().isEmpty() && functionDeclarationTree.descendants().noneMatch(tree -> !tree.equals(parameterTree.identifier()) && SyntacticEquivalence.areEquivalent(tree, parameterTree.identifier()))).collect(Collectors.toList());
    }

    protected void reportUnusedParameters(CheckContext ctx, List<ParameterTree> unusedParameters) {
        List<SecondaryLocation> secondaryLocations = unusedParameters.stream().map(unusedParameter -> {
            IdentifierTree identifier = unusedParameter.identifier();
            Objects.requireNonNull(identifier, "Identifier for an unused parameter is null");
            return new SecondaryLocation(identifier, "Remove this unused method parameter " + identifier.name() + "\".");
        }).collect(Collectors.toList());
        IdentifierTree firstUnused = unusedParameters.get(0).identifier();
        Objects.requireNonNull(firstUnused, "Identifier for an unused parameter is null");
        String msg = unusedParameters.size() > 1 ? "Remove these unused function parameters." : "Remove this unused function parameter \"" + firstUnused.name() + "\".";
        ctx.reportIssue((HasTextRange)firstUnused, msg, secondaryLocations);
    }

    protected boolean isValidFunctionForRule(CheckContext ctx, FunctionDeclarationTree tree) {
        return ctx.parent() instanceof TopLevelTree || FunctionUtils.isPrivateMethod(tree) && !FunctionUtils.isOverrideMethod(tree);
    }

    protected boolean shouldBeIgnored(CheckContext ctx, FunctionDeclarationTree tree) {
        IdentifierTree name = tree.name();
        boolean validFunctionForRule = this.isValidFunctionForRule(ctx, tree);
        return !validFunctionForRule || tree.body() == null || name != null && IGNORED_PATTERN.matcher(name.name()).matches();
    }
}

