/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.BaseTreeImpl;
import org.sonarsource.slang.impl.TextRanges;

public class MatchCaseTreeImpl
extends BaseTreeImpl
implements MatchCaseTree {
    private final Tree expression;
    private final Tree body;

    public MatchCaseTreeImpl(TreeMetaData metaData, @Nullable Tree expression, @Nullable Tree body) {
        super(metaData);
        this.expression = expression;
        this.body = body;
    }

    @Override
    @CheckForNull
    public Tree expression() {
        return this.expression;
    }

    @Override
    @CheckForNull
    public Tree body() {
        return this.body;
    }

    @Override
    public TextRange rangeToHighlight() {
        if (this.body == null) {
            return this.textRange();
        }
        TextRange bodyRange = this.body.metaData().textRange();
        List<TextRange> tokenRangesBeforeBody = this.metaData().tokens().stream().map(HasTextRange::textRange).filter(t -> t.start().compareTo(bodyRange.start()) < 0).collect(Collectors.toList());
        if (tokenRangesBeforeBody.isEmpty()) {
            return bodyRange;
        }
        return TextRanges.merge(tokenRangesBeforeBody);
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }
}

