/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.plugin.DurationStatistics;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class ChecksVisitor
extends TreeVisitor<InputFileContext> {
    private final DurationStatistics statistics;

    public ChecksVisitor(Checks<SlangCheck> checks, DurationStatistics statistics) {
        this.statistics = statistics;
        Collection rulesActiveInSonarQube = checks.all();
        for (SlangCheck check : rulesActiveInSonarQube) {
            RuleKey ruleKey = checks.ruleKey((Object)check);
            Objects.requireNonNull(ruleKey);
            check.initialize(new ContextAdapter(ruleKey));
        }
    }

    public class ContextAdapter
    implements InitContext,
    CheckContext {
        public final RuleKey ruleKey;
        private InputFileContext currentCtx;

        public ContextAdapter(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> visitor) {
            ChecksVisitor.this.register(cls, ChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = ctx;
                visitor.accept(this, tree);
            }));
        }

        @Override
        public Deque<Tree> ancestors() {
            return this.currentCtx.ancestors();
        }

        @Override
        public String filename() {
            return this.currentCtx.inputFile.filename();
        }

        @Override
        public String fileContent() {
            try {
                return this.currentCtx.inputFile.contents();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read content of " + this.currentCtx.inputFile, e);
            }
        }

        @Override
        public void reportIssue(TextRange textRange, String message) {
            this.reportIssue(textRange, message, Collections.emptyList(), null);
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message) {
            this.reportIssue(toHighlight, message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, SecondaryLocation secondaryLocation) {
            this.reportIssue(toHighlight, message, Collections.singletonList(secondaryLocation));
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations) {
            this.reportIssue(toHighlight, message, secondaryLocations, null);
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
            this.reportIssue(toHighlight.textRange(), message, secondaryLocations, gap);
        }

        @Override
        public void reportFileIssue(String message) {
            this.reportFileIssue(message, null);
        }

        @Override
        public void reportFileIssue(String message, @Nullable Double gap) {
            this.reportIssue((TextRange)null, message, Collections.emptyList(), gap);
        }

        private void reportIssue(@Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
            this.currentCtx.reportIssue(this.ruleKey, textRange, message, secondaryLocations, gap);
        }
    }
}

