/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class SyntaxHighlighter
extends TreeVisitor<InputFileContext> {
    private NewHighlighting newHighlighting;

    public SyntaxHighlighter() {
        this.register(TopLevelTree.class, (ctx, tree) -> {
            tree.allComments().forEach(comment -> this.highlight((InputFileContext)ctx, comment.textRange(), TypeOfText.COMMENT));
            tree.metaData().tokens().stream().filter(t -> t.type() == Token.Type.KEYWORD).forEach(token -> this.highlight((InputFileContext)ctx, token.textRange(), TypeOfText.KEYWORD));
        });
        this.register(LiteralTree.class, (ctx, tree) -> this.highlight((InputFileContext)ctx, tree.metaData().textRange(), tree instanceof StringLiteralTree ? TypeOfText.STRING : TypeOfText.CONSTANT));
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.newHighlighting = ctx.sensorContext.newHighlighting().onFile(ctx.inputFile);
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        this.newHighlighting.save();
    }

    private void highlight(InputFileContext ctx, TextRange range, TypeOfText typeOfText) {
        this.newHighlighting.highlight(ctx.textRange(range), typeOfText);
    }
}

