//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// The NSURLCacheStoragePolicy enum defines constants that
/// can be used to specify the type of storage that is allowable for an
/// NSCachedURLResponse object that is to be stored in an NSURLCache.
///
///
/// NSURLCache is allowed without restriction.
///
///
/// storage in an NSURLCache is allowed; however storage should be
/// done in memory only, no disk storage should be done.
///
///
/// NSURLCache is not allowed in any fashion, either in memory or on
/// disk.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcachestoragepolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLCacheStoragePolicy(pub NSUInteger);
impl NSURLCacheStoragePolicy {
    #[doc(alias = "NSURLCacheStorageAllowed")]
    pub const Allowed: Self = Self(0);
    #[doc(alias = "NSURLCacheStorageAllowedInMemoryOnly")]
    pub const AllowedInMemoryOnly: Self = Self(1);
    #[doc(alias = "NSURLCacheStorageNotAllowed")]
    pub const NotAllowed: Self = Self(2);
}

unsafe impl Encode for NSURLCacheStoragePolicy {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSURLCacheStoragePolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// NSCachedURLResponse is a class whose objects functions as a wrapper for
    /// objects that are stored in the framework's caching system.
    /// It is used to maintain characteristics and attributes of a cached
    /// object.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nscachedurlresponse?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCachedURLResponse;
);

unsafe impl Send for NSCachedURLResponse {}

unsafe impl Sync for NSCachedURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSCachedURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSCachedURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSCachedURLResponse {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSCachedURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSCachedURLResponse {}

impl NSCachedURLResponse {
    extern_methods!(
        #[cfg(all(feature = "NSData", feature = "NSURLResponse"))]
        /// Initializes an NSCachedURLResponse with the given
        /// response and data.
        ///
        /// A default NSURLCacheStoragePolicy is used for
        /// NSCachedURLResponse objects initialized with this method:
        /// NSURLCacheStorageAllowed.
        ///
        /// Parameter `response`: a NSURLResponse object.
        ///
        /// Parameter `data`: an NSData object representing the URL content
        /// corresponding to the given response.
        ///
        /// Returns: an initialized NSCachedURLResponse.
        #[unsafe(method(initWithResponse:data:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithResponse_data(
            this: Allocated<Self>,
            response: &NSURLResponse,
            data: &NSData,
        ) -> Retained<Self>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSDictionary",
            feature = "NSURLResponse"
        ))]
        /// Initializes an NSCachedURLResponse with the given
        /// response, data, user-info dictionary, and storage policy.
        ///
        /// Parameter `response`: a NSURLResponse object.
        ///
        /// Parameter `data`: an NSData object representing the URL content
        /// corresponding to the given response.
        ///
        /// Parameter `userInfo`: a dictionary user-specified information to be
        /// stored with the NSCachedURLResponse.
        ///
        /// Parameter `storagePolicy`: an NSURLCacheStoragePolicy constant.
        ///
        /// Returns: an initialized NSCachedURLResponse.
        #[unsafe(method(initWithResponse:data:userInfo:storagePolicy:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithResponse_data_userInfo_storagePolicy(
            this: Allocated<Self>,
            response: &NSURLResponse,
            data: &NSData,
            user_info: Option<&NSDictionary>,
            storage_policy: NSURLCacheStoragePolicy,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURLResponse")]
        /// Returns the response wrapped by this instance.
        ///
        /// Returns: The response wrapped by this instance.
        #[unsafe(method(response))]
        #[unsafe(method_family = none)]
        pub unsafe fn response(&self) -> Retained<NSURLResponse>;

        #[cfg(feature = "NSData")]
        /// Returns the data of the receiver.
        ///
        /// Returns: The data of the receiver.
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub unsafe fn data(&self) -> Retained<NSData>;

        #[cfg(feature = "NSDictionary")]
        /// Returns the userInfo dictionary of the receiver.
        ///
        /// Returns: The userInfo dictionary of the receiver.
        #[unsafe(method(userInfo))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInfo(&self) -> Option<Retained<NSDictionary>>;

        /// Returns the NSURLCacheStoragePolicy constant of the receiver.
        ///
        /// Returns: The NSURLCacheStoragePolicy constant of the receiver.
        #[unsafe(method(storagePolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn storagePolicy(&self) -> NSURLCacheStoragePolicy;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSCachedURLResponse {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcache?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLCache;
);

unsafe impl Send for NSURLCache {}

unsafe impl Sync for NSURLCache {}

unsafe impl NSObjectProtocol for NSURLCache {}

impl NSURLCache {
    extern_methods!(
        /// Returns the shared NSURLCache instance or
        /// sets the NSURLCache instance shared by all clients of
        /// the current process. This will be the new object returned when
        /// calls to the
        /// <tt>
        /// sharedURLCache
        /// </tt>
        /// method are made.
        ///
        /// Unless set explicitly through a call to
        /// <tt>
        /// +setSharedURLCache:
        /// </tt>
        /// , this method returns an NSURLCache
        /// instance created with the following default values:
        /// <ul>
        /// <li>
        /// Memory capacity: 4 megabytes (4 * 1024 * 1024 bytes)
        /// <li>
        /// Disk capacity: 20 megabytes (20 * 1024 * 1024 bytes)
        /// <li>
        /// Disk path:
        /// <nobr
        /// >(user home directory)/Library/Caches/(application bundle id)
        /// </nobr
        /// >
        /// </ul>
        /// <p>
        /// Users who do not have special caching requirements or
        /// constraints should find the default shared cache instance
        /// acceptable. If this default shared cache instance is not
        /// acceptable,
        /// <tt>
        /// +setSharedURLCache:
        /// </tt>
        /// can be called to set a
        /// different NSURLCache instance to be returned from this method.
        /// Callers should take care to ensure that the setter is called
        /// at a time when no other caller has a reference to the previously-set
        /// shared URL cache. This is to prevent storing cache data from
        /// becoming unexpectedly unretrievable.
        ///
        /// Returns: the shared NSURLCache instance.
        #[unsafe(method(sharedURLCache))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharedURLCache() -> Retained<NSURLCache>;

        /// Setter for [`sharedURLCache`][Self::sharedURLCache].
        #[unsafe(method(setSharedURLCache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSharedURLCache(shared_url_cache: &NSURLCache);

        #[cfg(feature = "NSString")]
        /// Initializes an NSURLCache with the given capacity and
        /// path.
        ///
        /// The returned NSURLCache is backed by disk, so
        /// developers can be more liberal with space when choosing the
        /// capacity for this kind of cache. A disk cache measured in the tens
        /// of megabytes should be acceptable in most cases.
        ///
        /// Parameter `memoryCapacity`: the capacity, measured in bytes, for the cache in memory.
        ///
        /// Parameter `diskCapacity`: the capacity, measured in bytes, for the cache on disk.
        ///
        /// Parameter `path`: the path on disk where the cache data is stored.
        ///
        /// Returns: an initialized NSURLCache, with the given capacity, backed
        /// by disk.
        #[deprecated]
        #[unsafe(method(initWithMemoryCapacity:diskCapacity:diskPath:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMemoryCapacity_diskCapacity_diskPath(
            this: Allocated<Self>,
            memory_capacity: NSUInteger,
            disk_capacity: NSUInteger,
            path: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        /// Initializes an NSURLCache with the given capacity and directory.
        ///
        /// Parameter `memoryCapacity`: the capacity, measured in bytes, for the cache in memory. Or 0 to disable memory cache.
        ///
        /// Parameter `diskCapacity`: the capacity, measured in bytes, for the cache on disk. Or 0 to disable disk cache.
        ///
        /// Parameter `directoryURL`: the path to a directory on disk where the cache data is stored. Or nil for default directory.
        ///
        /// Returns: an initialized NSURLCache, with the given capacity, optionally backed by disk.
        #[unsafe(method(initWithMemoryCapacity:diskCapacity:directoryURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMemoryCapacity_diskCapacity_directoryURL(
            this: Allocated<Self>,
            memory_capacity: NSUInteger,
            disk_capacity: NSUInteger,
            directory_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURLRequest")]
        /// Returns the NSCachedURLResponse stored in the cache with
        /// the given request.
        ///
        /// The method returns nil if there is no
        /// NSCachedURLResponse stored using the given request.
        ///
        /// Parameter `request`: the NSURLRequest to use as a key for the lookup.
        ///
        /// Returns: The NSCachedURLResponse stored in the cache with the given
        /// request, or nil if there is no NSCachedURLResponse stored with the
        /// given request.
        #[unsafe(method(cachedResponseForRequest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cachedResponseForRequest(
            &self,
            request: &NSURLRequest,
        ) -> Option<Retained<NSCachedURLResponse>>;

        #[cfg(feature = "NSURLRequest")]
        /// Stores the given NSCachedURLResponse in the cache using
        /// the given request.
        ///
        /// Parameter `cachedResponse`: The cached response to store.
        ///
        /// Parameter `request`: the NSURLRequest to use as a key for the storage.
        #[unsafe(method(storeCachedResponse:forRequest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn storeCachedResponse_forRequest(
            &self,
            cached_response: &NSCachedURLResponse,
            request: &NSURLRequest,
        );

        #[cfg(feature = "NSURLRequest")]
        /// Removes the NSCachedURLResponse from the cache that is
        /// stored using the given request.
        ///
        /// No action is taken if there is no NSCachedURLResponse
        /// stored with the given request.
        ///
        /// Parameter `request`: the NSURLRequest to use as a key for the lookup.
        #[unsafe(method(removeCachedResponseForRequest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCachedResponseForRequest(&self, request: &NSURLRequest);

        /// Clears the given cache, removing all NSCachedURLResponse
        /// objects that it stores.
        #[unsafe(method(removeAllCachedResponses))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllCachedResponses(&self);

        #[cfg(feature = "NSDate")]
        /// Clears the given cache of any cached responses since the provided date.
        #[unsafe(method(removeCachedResponsesSinceDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCachedResponsesSinceDate(&self, date: &NSDate);

        /// In-memory capacity of the receiver.
        ///
        /// At the time this call is made, the in-memory cache will truncate its contents to the size given, if necessary.
        ///
        /// Returns: The in-memory capacity, measured in bytes, for the receiver.
        #[unsafe(method(memoryCapacity))]
        #[unsafe(method_family = none)]
        pub unsafe fn memoryCapacity(&self) -> NSUInteger;

        /// Setter for [`memoryCapacity`][Self::memoryCapacity].
        #[unsafe(method(setMemoryCapacity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMemoryCapacity(&self, memory_capacity: NSUInteger);

        /// The on-disk capacity of the receiver.
        ///
        /// The on-disk capacity, measured in bytes, for the receiver. On mutation the on-disk cache will truncate its contents to the size given, if necessary.
        #[unsafe(method(diskCapacity))]
        #[unsafe(method_family = none)]
        pub unsafe fn diskCapacity(&self) -> NSUInteger;

        /// Setter for [`diskCapacity`][Self::diskCapacity].
        #[unsafe(method(setDiskCapacity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDiskCapacity(&self, disk_capacity: NSUInteger);

        /// Returns the current amount of space consumed by the
        /// in-memory cache of the receiver.
        ///
        /// This size, measured in bytes, indicates the current
        /// usage of the in-memory cache.
        ///
        /// Returns: the current usage of the in-memory cache of the receiver.
        #[unsafe(method(currentMemoryUsage))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentMemoryUsage(&self) -> NSUInteger;

        /// Returns the current amount of space consumed by the
        /// on-disk cache of the receiver.
        ///
        /// This size, measured in bytes, indicates the current
        /// usage of the on-disk cache.
        ///
        /// Returns: the current usage of the on-disk cache of the receiver.
        #[unsafe(method(currentDiskUsage))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentDiskUsage(&self) -> NSUInteger;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLCache {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSURLSessionTaskAdditions.
impl NSURLCache {
    extern_methods!(
        #[cfg(feature = "NSURLSession")]
        #[unsafe(method(storeCachedResponse:forDataTask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn storeCachedResponse_forDataTask(
            &self,
            cached_response: &NSCachedURLResponse,
            data_task: &NSURLSessionDataTask,
        );

        #[cfg(all(feature = "NSURLSession", feature = "block2"))]
        #[unsafe(method(getCachedResponseForDataTask:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCachedResponseForDataTask_completionHandler(
            &self,
            data_task: &NSURLSessionDataTask,
            completion_handler: &block2::Block<dyn Fn(*mut NSCachedURLResponse)>,
        );

        #[cfg(feature = "NSURLSession")]
        #[unsafe(method(removeCachedResponseForDataTask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCachedResponseForDataTask(&self, data_task: &NSURLSessionDataTask);
    );
}
