﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/ExploitAvailable.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Inspector2
  {
    namespace Model
    {
      namespace ExploitAvailableMapper
      {

        static const int YES_HASH = HashingUtils::HashString("YES");
        static const int NO_HASH = HashingUtils::HashString("NO");


        ExploitAvailable GetExploitAvailableForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == YES_HASH)
          {
            return ExploitAvailable::YES;
          }
          else if (hashCode == NO_HASH)
          {
            return ExploitAvailable::NO;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ExploitAvailable>(hashCode);
          }

          return ExploitAvailable::NOT_SET;
        }

        Aws::String GetNameForExploitAvailable(ExploitAvailable enumValue)
        {
          switch(enumValue)
          {
          case ExploitAvailable::YES:
            return "YES";
          case ExploitAvailable::NO:
            return "NO";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ExploitAvailableMapper
    } // namespace Model
  } // namespace Inspector2
} // namespace Aws
