import type * as webpack from 'webpack';
import { IFeatureDefinition } from './types';
import { EditorLanguage, EditorFeature, NegatedEditorFeature } from 'monaco-editor/esm/metadata';
interface IMonacoEditorWebpackPluginOpts {
    /**
     * Include only a subset of the languages supported.
     */
    languages?: EditorLanguage[];
    /**
     * Custom languages (outside of the ones shipped with the `monaco-editor`).
     */
    customLanguages?: IFeatureDefinition[];
    /**
     * Include only a subset of the editor features.
     * Use e.g. '!contextmenu' to exclude a certain feature.
     */
    features?: (EditorFeature | NegatedEditorFeature)[];
    /**
     * Specify a filename template to use for generated files.
     * Use e.g. '[name].worker.[contenthash].js' to include content-based hashes.
     */
    filename?: string;
    /**
     * The absolute file system path to the monaco-editor npm module.
     * Use e.g. `C:\projects\my-project\node-modules\monaco-editor`
     */
    monacoEditorPath?: string;
    /**
     * Override the public path from which files generated by this plugin will be served.
     * This wins out over Webpack's dynamic runtime path and can be useful to avoid attempting to load workers cross-
     * origin when using a CDN for other static resources.
     * Use e.g. '/' if you want to load your resources from the current origin.
     */
    publicPath?: string;
    /**
     * Specify whether the editor API should be exposed through a global `monaco` object or not. This
     * option is applicable to `0.22.0` and newer version of `monaco-editor`. Since `0.22.0`, the ESM
     * version of the monaco editor does no longer define a global `monaco` object unless
     * `global.MonacoEnvironment = { globalAPI: true }` is set ([change
     * log](https://github.com/microsoft/monaco-editor/blob/main/CHANGELOG.md#0220-29012021)).
     */
    globalAPI?: boolean;
}
declare class MonacoEditorWebpackPlugin implements webpack.WebpackPluginInstance {
    private readonly options;
    constructor(options?: IMonacoEditorWebpackPluginOpts);
    apply(compiler: webpack.Compiler): void;
}
export = MonacoEditorWebpackPlugin;
