import { ApiModel } from '@microsoft/api-extractor-model';
export interface IHugoMarkdownDocumenterParameters {
    draft: boolean;
    model: ApiModel;
    output: string;
}
/**
 * Renders API documentation in the Markdown file format.
 * For more info:  https://en.wikipedia.org/wiki/Markdown
 */
export declare class HugoMarkdownDocumenter {
    private readonly _apiModel;
    private readonly _tsdocConfiguration;
    private readonly _markdownEmitter;
    private readonly _outputFolder;
    private readonly _generateDraft;
    private readonly _pageTitleAppender;
    private readonly _headingAppender;
    private readonly _warningAppender;
    private readonly _importAppender;
    private readonly _signatureAppender;
    private readonly _summaryAppender;
    constructor(parameters: IHugoMarkdownDocumenterParameters);
    generateFiles(): void;
    private _writeApiItemPage;
    private _writeApiItemContent;
    private _writeRemarksSection;
    private _writeThrowsSection;
    /**
     * GENERATE PAGE: MODEL
     */
    private _writeModelTable;
    /**
     * GENERATE PAGE: PACKAGE or NAMESPACE
     */
    private _writePackageOrNamespaceTables;
    /**
     * GENERATE PAGE: CLASS
     */
    private _writeClassTables;
    /**
     * GENERATE PAGE: ENUM
     */
    private _writeEnumTables;
    /**
     * GENERATE PAGE: INTERFACE
     */
    private _writeInterfaceTables;
    /**
     * GENERATE PAGE: FUNCTION-LIKE
     */
    private _writeParameterTables;
    private _createTitleCell;
    private _getUrlDestination;
    /**
     * This generates a DocTableCell for an ApiItem including the summary section and "(BETA)" annotation.
     *
     * @remarks
     * We mostly assume that the input is an ApiDocumentedItem, but it's easier to perform this as a runtime
     * check than to have each caller perform a type cast.
     */
    private _createDescriptionCell;
    private _createModifiersCell;
    private _createPropertyTypeCell;
    private _appendSection;
    private _appendAndMergeSection;
    private _writeBoldText;
    private _getFilenameForApiItem;
    private _getLinkFilenameForApiItem;
    private _deleteOldOutputFiles;
}
//# sourceMappingURL=HugoMarkdownDocumenter.d.ts.map