"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GrafanaMarkdownEmitter = void 0;
const colors_1 = __importDefault(require("colors"));
const CustomMarkdownEmitter_1 = require("./CustomMarkdownEmitter");
class GrafanaMarkdownEmitter extends CustomMarkdownEmitter_1.CustomMarkdownEmitter {
    writeNode(docNode, context, docNodeSiblings) {
        const writer = context.writer;
        if (this._isGrafanaNode(docNode)) {
            return docNode.writeTo(writer);
        }
        super.writeNode(docNode, context, docNodeSiblings);
    }
    _isGrafanaNode(docNode) {
        const node = docNode;
        return node && node.writeTo !== undefined;
    }
    /** @override */
    writeLinkTagWithCodeDestination(docLinkTag, context) {
        const options = context.options;
        const result = this._apiModel.resolveDeclarationReference(docLinkTag.codeDestination, options.contextApiItem);
        if (result.resolvedApiItem) {
            const filename = options.onGetFilenameForApiItem(result.resolvedApiItem);
            if (filename) {
                let linkText = docLinkTag.linkText || '';
                if (linkText.length === 0) {
                    // Generate a name such as Namespace1.Namespace2.MyClass.myMethod()
                    linkText = result.resolvedApiItem.getScopedNameWithinPackage();
                }
                if (linkText.length > 0) {
                    const encodedLinkText = this.getEscapedText(linkText.replace(/\s+/g, ' '));
                    context.writer.write('[');
                    context.writer.write(encodedLinkText);
                    context.writer.write(`]({{< relref "${filename}" >}})`);
                }
                else {
                    console.log(colors_1.default.yellow('WARNING: Unable to determine link text'));
                }
            }
        }
        else if (result.errorMessage) {
            console.log(colors_1.default.yellow(`WARNING: Unable to resolve reference "${docLinkTag.codeDestination.emitAsTsdoc()}": ` +
                result.errorMessage));
        }
    }
}
exports.GrafanaMarkdownEmitter = GrafanaMarkdownEmitter;
//# sourceMappingURL=GrafanaMarkdownEmitter.js.map