/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;

public class LDAPBasePropertySupport
implements Serializable {
    public static final int OK = 0;
    public static final int INVALID_PARAMETER = 1;
    public static final int CONNECT_ERROR = 2;
    public static final int AUTHENTICATION_ERROR = 3;
    public static final int PROPERTY_NOT_FOUND = 4;
    public static final int AMBIGUOUS_RESULTS = 5;
    public static final int NO_SUCH_OBJECT = 6;
    private boolean _debug = false;
    private int _errCode = 0;
    private String _host = new String("localhost");
    private int _port = 389;
    private int _scope = 2;
    private String _base = new String("");
    private String _filter = new String("");
    private String _authDN = new String("");
    private String _authPassword = new String("");
    private String _userName = new String("");
    private String _userID = new String("");
    private transient PropertyChangeSupport m_propSupport = new PropertyChangeSupport(this);

    public String getHost() {
        return this._host;
    }

    public void setHost(String theHost) {
        this._host = theHost;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int thePort) {
        this._port = thePort;
    }

    public String getBase() {
        return this._base;
    }

    public void setBase(String theBase) {
        this._base = theBase;
    }

    public String getAuthDN() {
        return this._authDN;
    }

    public void setAuthDN(String authDN) {
        this._authDN = authDN;
    }

    public String getAuthPassword() {
        return this._authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this._authPassword = authPassword;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String name) {
        this._userName = name;
    }

    public String getUserID() {
        return this._userID;
    }

    public void setUserID(String name) {
        this._userID = name;
    }

    public int getScope() {
        return this._scope;
    }

    public void setScope(int scope) {
        this._scope = scope;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    public boolean getDebug() {
        return this._debug;
    }

    public void setDebug(boolean on) {
        this._debug = on;
    }

    public int getErrorCode() {
        return this._errCode;
    }

    public void setErrorCode(int code) {
        this._errCode = code;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.printDebug("Adding listener " + listener);
        this.m_propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.m_propSupport == null) {
            this.m_propSupport = new PropertyChangeSupport(this);
        }
        this.m_propSupport.firePropertyChange(propName, oldValue, newValue);
    }

    protected void printDebug(String s) {
        if (this._debug) {
            System.out.println(s);
        }
    }

    protected void connect(LDAPConnection conn, String host, int port) throws LDAPException {
        block14: {
            boolean needsPrivileges = true;
            SecurityManager sec = System.getSecurityManager();
            this.printDebug("Security manager = " + sec);
            if (sec == null) {
                this.printDebug("No security manager");
                needsPrivileges = false;
            } else if (sec.toString().startsWith("java.lang.NullSecurityManager")) {
                this.printDebug("No security manager");
                needsPrivileges = false;
            } else if (sec.toString().startsWith("netscape.security.AppletSecurity")) {
                try {
                    if (host.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                        needsPrivileges = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (needsPrivileges) {
                String mgr = "netscape.security.PrivilegeManager";
                try {
                    Class<?> c = Class.forName(mgr);
                    Method[] m = c.getMethods();
                    if (m == null) break block14;
                    for (int i = 0; i < m.length; ++i) {
                        if (!m[i].getName().equals("enablePrivilege")) continue;
                        try {
                            Object[] args = new Object[]{new String("UniversalConnect")};
                            m[i].invoke(null, args);
                            this.printDebug("UniversalConnect enabled");
                            args[0] = new String("UniversalPropertyRead");
                            m[i].invoke(null, args);
                            this.printDebug("UniversalPropertyRead enabled");
                        }
                        catch (Exception e) {
                            this.printDebug("Exception on invoking enablePrivilege: " + e.toString());
                        }
                        break;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.printDebug("no " + mgr);
                }
            }
        }
        conn.connect(host, port);
        this.setDefaultReferralCredentials(conn);
    }

    protected void setDefaultReferralCredentials(LDAPConnection conn) {
        final LDAPConnection m_conn = conn;
        LDAPRebind rebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                return new LDAPRebindAuth(){

                    public String getDN() {
                        return m_conn.getAuthenticationDN();
                    }

                    public String getPassword() {
                        return m_conn.getAuthenticationPassword();
                    }
                };
            }
        };
        try {
            conn.setOption(8, (Object)Boolean.TRUE);
            conn.setOption(9, (Object)rebind);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    public String convertToString(String[] aResult) {
        Object sResult = "";
        if (null != aResult) {
            for (int i = 0; i < aResult.length; ++i) {
                sResult = (String)sResult + aResult[i] + "\n";
            }
        }
        return sResult;
    }
}

