/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the ArtifactDistributionResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ArtifactDistributionResponse{}

// ArtifactDistributionResponse A serializer for ArtifactDistribution.
type ArtifactDistributionResponse struct {
	// The URL for accessing the publication as defined by this distribution.
	BaseUrl *string `json:"base_url,omitempty"`
	PulpHref *string `json:"pulp_href,omitempty"`
	// The base (relative) path component of the published url. Avoid paths that                     overlap with other distribution base paths (e.g. \"foo\" and \"foo/bar\")
	BasePath string `json:"base_path"`
	// A unique name. Ex, `rawhide` and `stable`.
	Name string `json:"name"`
	// Whether this distribution should be shown in the content app.
	Hidden *bool `json:"hidden,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	PulpLabels *map[string]string `json:"pulp_labels,omitempty"`
	// An optional content-guard.
	ContentGuard NullableString `json:"content_guard,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ArtifactDistributionResponse ArtifactDistributionResponse

// NewArtifactDistributionResponse instantiates a new ArtifactDistributionResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewArtifactDistributionResponse(basePath string, name string) *ArtifactDistributionResponse {
	this := ArtifactDistributionResponse{}
	this.BasePath = basePath
	this.Name = name
	var hidden bool = false
	this.Hidden = &hidden
	return &this
}

// NewArtifactDistributionResponseWithDefaults instantiates a new ArtifactDistributionResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewArtifactDistributionResponseWithDefaults() *ArtifactDistributionResponse {
	this := ArtifactDistributionResponse{}
	var hidden bool = false
	this.Hidden = &hidden
	return &this
}

// GetBaseUrl returns the BaseUrl field value if set, zero value otherwise.
func (o *ArtifactDistributionResponse) GetBaseUrl() string {
	if o == nil || IsNil(o.BaseUrl) {
		var ret string
		return ret
	}
	return *o.BaseUrl
}

// GetBaseUrlOk returns a tuple with the BaseUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetBaseUrlOk() (*string, bool) {
	if o == nil || IsNil(o.BaseUrl) {
		return nil, false
	}
	return o.BaseUrl, true
}

// HasBaseUrl returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasBaseUrl() bool {
	if o != nil && !IsNil(o.BaseUrl) {
		return true
	}

	return false
}

// SetBaseUrl gets a reference to the given string and assigns it to the BaseUrl field.
func (o *ArtifactDistributionResponse) SetBaseUrl(v string) {
	o.BaseUrl = &v
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *ArtifactDistributionResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *ArtifactDistributionResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetBasePath returns the BasePath field value
func (o *ArtifactDistributionResponse) GetBasePath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BasePath
}

// GetBasePathOk returns a tuple with the BasePath field value
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetBasePathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BasePath, true
}

// SetBasePath sets field value
func (o *ArtifactDistributionResponse) SetBasePath(v string) {
	o.BasePath = v
}

// GetName returns the Name field value
func (o *ArtifactDistributionResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *ArtifactDistributionResponse) SetName(v string) {
	o.Name = v
}

// GetHidden returns the Hidden field value if set, zero value otherwise.
func (o *ArtifactDistributionResponse) GetHidden() bool {
	if o == nil || IsNil(o.Hidden) {
		var ret bool
		return ret
	}
	return *o.Hidden
}

// GetHiddenOk returns a tuple with the Hidden field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetHiddenOk() (*bool, bool) {
	if o == nil || IsNil(o.Hidden) {
		return nil, false
	}
	return o.Hidden, true
}

// HasHidden returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasHidden() bool {
	if o != nil && !IsNil(o.Hidden) {
		return true
	}

	return false
}

// SetHidden gets a reference to the given bool and assigns it to the Hidden field.
func (o *ArtifactDistributionResponse) SetHidden(v bool) {
	o.Hidden = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *ArtifactDistributionResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *ArtifactDistributionResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetPulpLabels returns the PulpLabels field value if set, zero value otherwise.
func (o *ArtifactDistributionResponse) GetPulpLabels() map[string]string {
	if o == nil || IsNil(o.PulpLabels) {
		var ret map[string]string
		return ret
	}
	return *o.PulpLabels
}

// GetPulpLabelsOk returns a tuple with the PulpLabels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactDistributionResponse) GetPulpLabelsOk() (*map[string]string, bool) {
	if o == nil || IsNil(o.PulpLabels) {
		return nil, false
	}
	return o.PulpLabels, true
}

// HasPulpLabels returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasPulpLabels() bool {
	if o != nil && !IsNil(o.PulpLabels) {
		return true
	}

	return false
}

// SetPulpLabels gets a reference to the given map[string]string and assigns it to the PulpLabels field.
func (o *ArtifactDistributionResponse) SetPulpLabels(v map[string]string) {
	o.PulpLabels = &v
}

// GetContentGuard returns the ContentGuard field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactDistributionResponse) GetContentGuard() string {
	if o == nil || IsNil(o.ContentGuard.Get()) {
		var ret string
		return ret
	}
	return *o.ContentGuard.Get()
}

// GetContentGuardOk returns a tuple with the ContentGuard field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactDistributionResponse) GetContentGuardOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ContentGuard.Get(), o.ContentGuard.IsSet()
}

// HasContentGuard returns a boolean if a field has been set.
func (o *ArtifactDistributionResponse) HasContentGuard() bool {
	if o != nil && o.ContentGuard.IsSet() {
		return true
	}

	return false
}

// SetContentGuard gets a reference to the given NullableString and assigns it to the ContentGuard field.
func (o *ArtifactDistributionResponse) SetContentGuard(v string) {
	o.ContentGuard.Set(&v)
}
// SetContentGuardNil sets the value for ContentGuard to be an explicit nil
func (o *ArtifactDistributionResponse) SetContentGuardNil() {
	o.ContentGuard.Set(nil)
}

// UnsetContentGuard ensures that no value is present for ContentGuard, not even an explicit nil
func (o *ArtifactDistributionResponse) UnsetContentGuard() {
	o.ContentGuard.Unset()
}

func (o ArtifactDistributionResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ArtifactDistributionResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.BaseUrl) {
		toSerialize["base_url"] = o.BaseUrl
	}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	toSerialize["base_path"] = o.BasePath
	toSerialize["name"] = o.Name
	if !IsNil(o.Hidden) {
		toSerialize["hidden"] = o.Hidden
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.PulpLabels) {
		toSerialize["pulp_labels"] = o.PulpLabels
	}
	if o.ContentGuard.IsSet() {
		toSerialize["content_guard"] = o.ContentGuard.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ArtifactDistributionResponse) UnmarshalJSON(bytes []byte) (err error) {
	varArtifactDistributionResponse := _ArtifactDistributionResponse{}

	if err = json.Unmarshal(bytes, &varArtifactDistributionResponse); err == nil {
		*o = ArtifactDistributionResponse(varArtifactDistributionResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "base_url")
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "base_path")
		delete(additionalProperties, "name")
		delete(additionalProperties, "hidden")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "pulp_labels")
		delete(additionalProperties, "content_guard")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableArtifactDistributionResponse struct {
	value *ArtifactDistributionResponse
	isSet bool
}

func (v NullableArtifactDistributionResponse) Get() *ArtifactDistributionResponse {
	return v.value
}

func (v *NullableArtifactDistributionResponse) Set(val *ArtifactDistributionResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableArtifactDistributionResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableArtifactDistributionResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableArtifactDistributionResponse(val *ArtifactDistributionResponse) *NullableArtifactDistributionResponse {
	return &NullableArtifactDistributionResponse{value: val, isSet: true}
}

func (v NullableArtifactDistributionResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableArtifactDistributionResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


