/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -8963439897419343166L;
    public static final String OID = "2.5.29.54";
    public static final String NAME = "InhibitAnyPolicyExtension";
    private BigInt mSkipCerts = new BigInt(-1);

    public InhibitAnyPolicyExtension() throws IOException {
        this(false, null);
    }

    public InhibitAnyPolicyExtension(boolean crit, BigInt skipCerts) throws IOException {
        try {
            this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.critical = crit;
        this.mSkipCerts = skipCerts;
        this.encodeExtValue();
    }

    public InhibitAnyPolicyExtension(Boolean crit, Object value) throws IOException {
        this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        this.critical = crit;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        this.decodeThis();
    }

    @Override
    public void setCritical(boolean newValue) {
        if (this.critical != newValue) {
            this.critical = newValue;
        }
    }

    public BigInt getSkipCerts() {
        return this.mSkipCerts;
    }

    @Override
    public String toString() {
        Object presentation = "ObjectId: 2.5.29.54 ";
        presentation = this.critical ? (String)presentation + "Criticality=true" : (String)presentation + "Criticality=false";
        if (this.extensionValue != null) {
            String extByteValue = " skipCerts=" + this.mSkipCerts;
            presentation = (String)presentation + extByteValue;
        }
        return presentation;
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
    }

    private void decodeThis() throws IOException {
        DerValue val = new DerValue(this.extensionValue);
        this.mSkipCerts = val.getInteger();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            if (this.extensionValue == null) {
                try {
                    this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                os.putInteger(this.mSkipCerts);
                this.extensionValue = os.toByteArray();
            }
            super.encode(tmp);
            out.write(tmp.toByteArray());
        }
    }

    private void encodeExtValue() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            out.putInteger(this.mSkipCerts);
        }
        this.extensionValue = out.toByteArray();
    }

    static {
        try {
            OIDMap.addAttribute(InhibitAnyPolicyExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

