/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;

public class SignerInfo
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CONTENT_TYPE = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(3L);
    private static final OBJECT_IDENTIFIER MESSAGE_DIGEST = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(4L);
    private INTEGER version;
    private SignerIdentifier signerIdentifier;
    private AlgorithmIdentifier digestAlgorithm;
    private SET signedAttributes;
    private AlgorithmIdentifier digestEncryptionAlgorithm;
    private OCTET_STRING encryptedDigest;
    private SET unsignedAttributes;
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.signerIdentifier;
    }

    public DigestAlgorithm getDigestAlgorithm() throws NoSuchAlgorithmException {
        return DigestAlgorithm.fromOID(this.digestAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifer() {
        return this.digestAlgorithm;
    }

    public SET getSignedAttributes() {
        return this.signedAttributes;
    }

    public boolean hasSignedAttributes() {
        return this.signedAttributes != null;
    }

    public SignatureAlgorithm getDigestEncryptionAlgorithm() throws NoSuchAlgorithmException {
        return SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithmIdentifier() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest.toByteArray();
    }

    public SET getUnsignedAttributes() {
        return this.unsignedAttributes;
    }

    public boolean hasUnsignedAttributes() {
        return this.unsignedAttributes != null;
    }

    public SignerInfo(SignerIdentifier signerIdentifier, SET signedAttributes, SET unsignedAttributes, OBJECT_IDENTIFIER contentType, byte[] messageDigest, SignatureAlgorithm signingAlg, PrivateKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException, NotInitializedException, SignatureException, TokenException {
        Signature sig;
        if (signerIdentifier == null) {
            throw new IllegalArgumentException("SignerIdentifier may not be null");
        }
        this.signerIdentifier = signerIdentifier;
        if (SignerIdentifier.ISSUER_AND_SERIALNUMBER.equals(this.signerIdentifier.getType())) {
            this.version = new INTEGER(1L);
        } else if (SignerIdentifier.SUBJECT_KEY_IDENTIFIER.equals(this.signerIdentifier.getType())) {
            this.version = new INTEGER(3L);
        } else {
            throw new IllegalArgumentException("Unexpected SignerIdentifier type");
        }
        this.digestAlgorithm = new AlgorithmIdentifier(signingAlg.getDigestAlg().toOID(), null);
        if (!contentType.equals(ContentInfo.DATA)) {
            if (signedAttributes == null) {
                signedAttributes = new SET();
            }
            Attribute attrib = new Attribute(CONTENT_TYPE, contentType);
            signedAttributes.addElement(attrib);
            attrib = new Attribute(MESSAGE_DIGEST, new OCTET_STRING(messageDigest));
            signedAttributes.addElement(attrib);
        }
        this.digestEncryptionAlgorithm = new AlgorithmIdentifier(signingAlg.toOID(), null);
        if (signedAttributes != null) {
            assert (signedAttributes.size() >= 2);
            this.signedAttributes = signedAttributes;
        }
        CryptoToken token = signingKey.getOwningToken();
        byte[] toBeSigned = null;
        if (signedAttributes == null) {
            if (signingAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
                SEQUENCE digestInfo = this.createDigestInfo(messageDigest, false);
                toBeSigned = ASN1Util.encode(digestInfo);
            } else {
                toBeSigned = messageDigest;
            }
            sig = token.getSignatureContext(signingAlg.getRawAlg());
        } else {
            byte[] encoding = ASN1Util.encode(signedAttributes);
            if (signingAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
                SEQUENCE digestInfo = this.createDigestInfo(encoding, true);
                toBeSigned = ASN1Util.encode(digestInfo);
                sig = token.getSignatureContext(SignatureAlgorithm.RSASignature);
            } else {
                toBeSigned = encoding;
                sig = token.getSignatureContext(signingAlg);
            }
        }
        sig.initSign(signingKey);
        sig.update(toBeSigned);
        this.encryptedDigest = new OCTET_STRING(sig.sign());
        if (unsignedAttributes != null) {
            this.unsignedAttributes = unsignedAttributes;
        }
    }

    SignerInfo(INTEGER version, SignerIdentifier signerIdentifier, AlgorithmIdentifier digestAlgorithm, SET signedAttributes, AlgorithmIdentifier digestEncryptionAlgorithm, byte[] encryptedDigest, SET unsignedAttributes) {
        this.version = version;
        this.signerIdentifier = signerIdentifier;
        this.digestAlgorithm = digestAlgorithm;
        this.signedAttributes = signedAttributes;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
        this.encryptedDigest = new OCTET_STRING(encryptedDigest);
        this.unsignedAttributes = unsignedAttributes;
    }

    public void verify(byte[] messageDigest, OBJECT_IDENTIFIER contentType) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException, ObjectNotFoundException {
        CryptoManager cm = CryptoManager.getInstance();
        if (this.signerIdentifier.getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) {
            IssuerAndSerialNumber issuerAndSerialNumber = this.signerIdentifier.getIssuerAndSerialNumber();
            X509Certificate cert = cm.findCertByIssuerAndSerialNumber(ASN1Util.encode(issuerAndSerialNumber.getIssuer()), issuerAndSerialNumber.getSerialNumber());
            this.verify(messageDigest, contentType, cert.getPublicKey());
        } else assert (this.signerIdentifier.getType().equals(SignerIdentifier.SUBJECT_KEY_IDENTIFIER));
    }

    public void verify(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        if (this.signedAttributes == null) {
            this.verifyWithoutSignedAttributes(messageDigest, contentType, pubkey);
        } else {
            this.verifyWithSignedAttributes(messageDigest, contentType, pubkey);
        }
    }

    private void verifyWithoutSignedAttributes(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        Signature sig;
        byte[] toBeVerified;
        if (!contentType.equals(ContentInfo.DATA)) {
            throw new SignatureException("Content-Type is not DATA, but there are no signed attributes");
        }
        SignatureAlgorithm sigAlg = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        if (sigAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE digestInfo = this.createDigestInfo(messageDigest, false);
            toBeVerified = ASN1Util.encode(digestInfo);
            sig = token.getSignatureContext(sigAlg.getRawAlg());
        } else {
            toBeVerified = messageDigest;
            sig = token.getSignatureContext(sigAlg);
        }
        sig.initVerify(pubkey);
        sig.update(toBeVerified);
        if (sig.verify(this.encryptedDigest.toByteArray())) {
            return;
        }
        throw new SignatureException("Encrypted message digest parameter does not match encrypted digest in SignerInfo");
    }

    private void verifyWithSignedAttributes(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        Signature sig;
        byte[] toBeVerified;
        int numAttrib = this.signedAttributes.size();
        if (numAttrib < 2) {
            throw new SignatureException("At least two signed attributes must be present: content-type and message-digest");
        }
        boolean foundContentType = false;
        boolean foundMessageDigest = false;
        for (int i = 0; i < numAttrib; ++i) {
            byte[] mdigest;
            block22: {
                ASN1Value val;
                SET vals;
                if (!(this.signedAttributes.elementAt(i) instanceof Attribute)) {
                    throw new SignatureException("Element of signedAttributes is not an Attribute");
                }
                Attribute attrib = (Attribute)this.signedAttributes.elementAt(i);
                if (attrib.getType().equals(CONTENT_TYPE)) {
                    OBJECT_IDENTIFIER ctype;
                    block21: {
                        vals = attrib.getValues();
                        if (vals.size() != 1) {
                            throw new SignatureException("Content-Type attribute  does not have exactly one value");
                        }
                        val = vals.elementAt(0);
                        try {
                            if (val instanceof OBJECT_IDENTIFIER) {
                                ctype = (OBJECT_IDENTIFIER)val;
                                break block21;
                            }
                            if (val instanceof ANY) {
                                ctype = (OBJECT_IDENTIFIER)((ANY)val).decodeWith(OBJECT_IDENTIFIER.getTemplate());
                                break block21;
                            }
                            throw new InvalidBERException("Content-Type signed attribute has unexpected content type");
                        }
                        catch (InvalidBERException e) {
                            throw new SignatureException("Content-Type signed attribute does not have OBJECT IDENTIFIER value");
                        }
                    }
                    if (!ctype.equals(contentType)) {
                        throw new SignatureException("Content-type in signed attributes does not match content-type being verified");
                    }
                    foundContentType = true;
                    continue;
                }
                if (!attrib.getType().equals(MESSAGE_DIGEST)) continue;
                vals = attrib.getValues();
                if (vals.size() != 1) {
                    throw new SignatureException("Message-digest attribute does not have exactly one value");
                }
                val = vals.elementAt(0);
                try {
                    if (val instanceof OCTET_STRING) {
                        mdigest = ((OCTET_STRING)val).toByteArray();
                        break block22;
                    }
                    if (val instanceof ANY) {
                        OCTET_STRING os = (OCTET_STRING)((ANY)val).decodeWith(OCTET_STRING.getTemplate());
                        mdigest = os.toByteArray();
                        break block22;
                    }
                    throw new InvalidBERException("Content-Type signed attribute has unexpected content type");
                }
                catch (InvalidBERException e) {
                    throw new SignatureException("Message-digest attribute does not have OCTET STRING value");
                }
            }
            if (!SignerInfo.byteArraysAreSame(mdigest, messageDigest)) {
                throw new SignatureException("Message-digest attribute does not match message digest being verified");
            }
            foundMessageDigest = true;
        }
        if (!foundContentType) {
            throw new SignatureException("Signed attributes does not contain PKCS #9 content-type attribute");
        }
        if (!foundMessageDigest) {
            throw new SignatureException("Signed attributes does not contain PKCS #9 message-digest attribute");
        }
        SignatureAlgorithm sigAlg = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        byte[] encoding = ASN1Util.encode(this.signedAttributes);
        if (sigAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE digestInfo = this.createDigestInfo(encoding, true);
            toBeVerified = ASN1Util.encode(digestInfo);
            sig = token.getSignatureContext(SignatureAlgorithm.RSASignature);
        } else {
            toBeVerified = encoding;
            sig = token.getSignatureContext(sigAlg);
        }
        sig.initVerify(pubkey);
        sig.update(toBeVerified);
        if (!sig.verify(this.encryptedDigest.toByteArray())) {
            throw new SignatureException("encryptedDigest was not the correct signature of the contents octets of the DER-encoded signed attributes");
        }
    }

    private SEQUENCE createDigestInfo(byte[] data, boolean doDigest) throws NoSuchAlgorithmException {
        byte[] digest;
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data to digest must be supplied");
        }
        SEQUENCE digestInfo = new SEQUENCE();
        digestInfo.addElement(this.digestAlgorithm);
        if (doDigest) {
            MessageDigest md = MessageDigest.getInstance(DigestAlgorithm.fromOID(this.digestAlgorithm.getOID()).toString());
            digest = md.digest(data);
        } else {
            digest = data;
        }
        digestInfo.addElement(new OCTET_STRING(digest));
        return digestInfo;
    }

    private static boolean byteArraysAreSame(byte[] left, byte[] right) {
        assert (left != null && right != null);
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement(this.version);
        sequence.addElement(this.signerIdentifier);
        sequence.addElement(this.digestAlgorithm);
        if (this.signedAttributes != null) {
            sequence.addElement(new Tag(0L), this.signedAttributes);
        }
        sequence.addElement(this.digestEncryptionAlgorithm);
        sequence.addElement(this.encryptedDigest);
        if (this.unsignedAttributes != null) {
            sequence.addElement(new Tag(1L), this.unsignedAttributes);
        }
        sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(SignerIdentifier.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Attribute.getTemplate()));
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(Attribute.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            assert (seq.size() == 7);
            return new SignerInfo((INTEGER)seq.elementAt(0), (SignerIdentifier)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (SET)seq.elementAt(3), (AlgorithmIdentifier)seq.elementAt(4), ((OCTET_STRING)seq.elementAt(5)).toByteArray(), (SET)seq.elementAt(6));
        }
    }
}

