/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// PublicationsRpmAPIService PublicationsRpmAPI service
type PublicationsRpmAPIService service

type PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
	nestedRole *NestedRole
}

func (r PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest) NestedRole(nestedRole NestedRole) PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmAddRoleExecute(r)
}

/*
PublicationsRpmRpmAddRole Method for PublicationsRpmRpmAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmAddRole(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest {
	return PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmAddRoleExecute(r PublicationsRpmAPIPublicationsRpmRpmAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmCreateRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublication *RpmRpmPublication
}

func (r PublicationsRpmAPIPublicationsRpmRpmCreateRequest) RpmRpmPublication(rpmRpmPublication RpmRpmPublication) PublicationsRpmAPIPublicationsRpmRpmCreateRequest {
	r.rpmRpmPublication = &rpmRpmPublication
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmCreateExecute(r)
}

/*
PublicationsRpmRpmCreate Create a rpm publication

Trigger an asynchronous task to create a new RPM content publication.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsRpmAPIPublicationsRpmRpmCreateRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmCreate(ctx context.Context) PublicationsRpmAPIPublicationsRpmRpmCreateRequest {
	return PublicationsRpmAPIPublicationsRpmRpmCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmCreateExecute(r PublicationsRpmAPIPublicationsRpmRpmCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmPublication == nil {
		return localVarReturnValue, nil, reportError("rpmRpmPublication is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmPublication
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmDeleteRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
}

func (r PublicationsRpmAPIPublicationsRpmRpmDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.PublicationsRpmRpmDeleteExecute(r)
}

/*
PublicationsRpmRpmDelete Delete a rpm publication

ViewSet for Rpm Publications.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmDeleteRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmDelete(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmDeleteRequest {
	return PublicationsRpmAPIPublicationsRpmRpmDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
func (a *PublicationsRpmAPIService) PublicationsRpmRpmDeleteExecute(r PublicationsRpmAPIPublicationsRpmRpmDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmListRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	content *string
	contentIn *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repository *string
	repositoryVersion *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Content(content string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) ContentIn(contentIn string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Limit(limit int32) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Offset(offset int32) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;pass_through&#x60; - Pass through * &#x60;-pass_through&#x60; - Pass through (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Ordering(ordering []string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreated(pulpCreated time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreatedGt(pulpCreatedGt time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreatedGte(pulpCreatedGte time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreatedLt(pulpCreatedLt time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreatedLte(pulpCreatedLte time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpHrefIn(pulpHrefIn []string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) PulpIdIn(pulpIdIn []string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository referenced by HREF
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Repository(repository string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.repository = &repository
	return r
}

// Repository Version referenced by HREF
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) RepositoryVersion(repositoryVersion string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// A list of fields to include in the response.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Fields(fields []string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) ExcludeFields(excludeFields []string) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmListRequest) Execute() (*PaginatedrpmRpmPublicationResponseList, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmListExecute(r)
}

/*
PublicationsRpmRpmList List rpm publications

ViewSet for Rpm Publications.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsRpmAPIPublicationsRpmRpmListRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmList(ctx context.Context) PublicationsRpmAPIPublicationsRpmRpmListRequest {
	return PublicationsRpmAPIPublicationsRpmRpmListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmRpmPublicationResponseList
func (a *PublicationsRpmAPIService) PublicationsRpmRpmListExecute(r PublicationsRpmAPIPublicationsRpmRpmListRequest) (*PaginatedrpmRpmPublicationResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmRpmPublicationResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmListRolesRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PublicationsRpmAPIPublicationsRpmRpmListRolesRequest) Fields(fields []string) PublicationsRpmAPIPublicationsRpmRpmListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsRpmAPIPublicationsRpmRpmListRolesRequest) ExcludeFields(excludeFields []string) PublicationsRpmAPIPublicationsRpmRpmListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmListRolesExecute(r)
}

/*
PublicationsRpmRpmListRoles Method for PublicationsRpmRpmListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmListRolesRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmListRoles(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmListRolesRequest {
	return PublicationsRpmAPIPublicationsRpmRpmListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmListRolesExecute(r PublicationsRpmAPIPublicationsRpmRpmListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest) Fields(fields []string) PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest) ExcludeFields(excludeFields []string) PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmMyPermissionsExecute(r)
}

/*
PublicationsRpmRpmMyPermissions Method for PublicationsRpmRpmMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmMyPermissions(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest {
	return PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmMyPermissionsExecute(r PublicationsRpmAPIPublicationsRpmRpmMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmReadRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PublicationsRpmAPIPublicationsRpmRpmReadRequest) Fields(fields []string) PublicationsRpmAPIPublicationsRpmRpmReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsRpmAPIPublicationsRpmRpmReadRequest) ExcludeFields(excludeFields []string) PublicationsRpmAPIPublicationsRpmRpmReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmReadRequest) Execute() (*RpmRpmPublicationResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmReadExecute(r)
}

/*
PublicationsRpmRpmRead Inspect a rpm publication

ViewSet for Rpm Publications.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmReadRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmRead(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmReadRequest {
	return PublicationsRpmAPIPublicationsRpmRpmReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
//  @return RpmRpmPublicationResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmReadExecute(r PublicationsRpmAPIPublicationsRpmRpmReadRequest) (*RpmRpmPublicationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmPublicationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest struct {
	ctx context.Context
	ApiService *PublicationsRpmAPIService
	rpmRpmPublicationHref string
	nestedRole *NestedRole
}

func (r PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest) NestedRole(nestedRole NestedRole) PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.PublicationsRpmRpmRemoveRoleExecute(r)
}

/*
PublicationsRpmRpmRemoveRole Method for PublicationsRpmRpmRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmPublicationHref
 @return PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest
*/
func (a *PublicationsRpmAPIService) PublicationsRpmRpmRemoveRole(ctx context.Context, rpmRpmPublicationHref string) PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest {
	return PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmPublicationHref: rpmRpmPublicationHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *PublicationsRpmAPIService) PublicationsRpmRpmRemoveRoleExecute(r PublicationsRpmAPIPublicationsRpmRpmRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsRpmAPIService.PublicationsRpmRpmRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_publication_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_publication_href"+"}", parameterValueToString(r.rpmRpmPublicationHref, "rpmRpmPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
