/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"encoding/json"
	"encoding/xml"
	"errors"
	"fmt"
	"io"
	"log"
	"mime/multipart"
	"net/http"
	"net/http/httputil"
	"net/url"
	"os"
	"path/filepath"
	"reflect"
	"regexp"
	"strconv"
	"strings"
	"time"
	"unicode/utf8"

)

var (
	jsonCheck = regexp.MustCompile(`(?i:(?:application|text)/(?:vnd\.[^;]+\+)?json)`)
	xmlCheck  = regexp.MustCompile(`(?i:(?:application|text)/xml)`)
	queryParamSplit = regexp.MustCompile(`(^|&)([^&]+)`)
	queryDescape    = strings.NewReplacer( "%5B", "[", "%5D", "]" )
)

// APIClient manages communication with the Pulp 3 API API vv3
// In most cases there should be only one, shared, APIClient.
type APIClient struct {
	cfg    *Configuration
	common service // Reuse a single struct instead of allocating one for each service on the heap.

	// API Services

	AccessPoliciesAPI *AccessPoliciesAPIService

	AcsFileAPI *AcsFileAPIService

	AcsRpmAPI *AcsRpmAPIService

	AnsibleCollectionsAPI *AnsibleCollectionsAPIService

	AnsibleCopyAPI *AnsibleCopyAPIService

	ApiCollectionsAPI *ApiCollectionsAPIService

	ApiRolesAPI *ApiRolesAPIService

	ArtifactsAPI *ArtifactsAPIService

	CollectionImportAPI *CollectionImportAPIService

	ContentAPI *ContentAPIService

	ContentAdvisoriesAPI *ContentAdvisoriesAPIService

	ContentArtifactAPI *ContentArtifactAPIService

	ContentBlobsAPI *ContentBlobsAPIService

	ContentCollectionDeprecationsAPI *ContentCollectionDeprecationsAPIService

	ContentCollectionMarksAPI *ContentCollectionMarksAPIService

	ContentCollectionSignaturesAPI *ContentCollectionSignaturesAPIService

	ContentCollectionVersionsAPI *ContentCollectionVersionsAPIService

	ContentCommitsAPI *ContentCommitsAPIService

	ContentConfigsAPI *ContentConfigsAPIService

	ContentContentAPI *ContentContentAPIService

	ContentDistributionTreesAPI *ContentDistributionTreesAPIService

	ContentFilesAPI *ContentFilesAPIService

	ContentGemAPI *ContentGemAPIService

	ContentGenericContentsAPI *ContentGenericContentsAPIService

	ContentInstallerFileIndicesAPI *ContentInstallerFileIndicesAPIService

	ContentInstallerPackagesAPI *ContentInstallerPackagesAPIService

	ContentManifestsAPI *ContentManifestsAPIService

	ContentModulemdDefaultsAPI *ContentModulemdDefaultsAPIService

	ContentModulemdObsoletesAPI *ContentModulemdObsoletesAPIService

	ContentModulemdsAPI *ContentModulemdsAPIService

	ContentNamespacesAPI *ContentNamespacesAPIService

	ContentObjectsAPI *ContentObjectsAPIService

	ContentPackageIndicesAPI *ContentPackageIndicesAPIService

	ContentPackageReleaseComponentsAPI *ContentPackageReleaseComponentsAPIService

	ContentPackagecategoriesAPI *ContentPackagecategoriesAPIService

	ContentPackageenvironmentsAPI *ContentPackageenvironmentsAPIService

	ContentPackagegroupsAPI *ContentPackagegroupsAPIService

	ContentPackagelangpacksAPI *ContentPackagelangpacksAPIService

	ContentPackagesAPI *ContentPackagesAPIService

	ContentRefsAPI *ContentRefsAPIService

	ContentReleaseArchitecturesAPI *ContentReleaseArchitecturesAPIService

	ContentReleaseComponentsAPI *ContentReleaseComponentsAPIService

	ContentReleaseFilesAPI *ContentReleaseFilesAPIService

	ContentReleasesAPI *ContentReleasesAPIService

	ContentRepoMetadataFilesAPI *ContentRepoMetadataFilesAPIService

	ContentRolesAPI *ContentRolesAPIService

	ContentSignaturesAPI *ContentSignaturesAPIService

	ContentSummariesAPI *ContentSummariesAPIService

	ContentTagsAPI *ContentTagsAPIService

	ContentguardsAPI *ContentguardsAPIService

	ContentguardsContentRedirectAPI *ContentguardsContentRedirectAPIService

	ContentguardsRbacAPI *ContentguardsRbacAPIService

	ContentguardsRhsmAPI *ContentguardsRhsmAPIService

	ContentguardsX509API *ContentguardsX509APIService

	DebCopyAPI *DebCopyAPIService

	DistributionsAPI *DistributionsAPIService

	DistributionsAnsibleAPI *DistributionsAnsibleAPIService

	DistributionsAptAPI *DistributionsAptAPIService

	DistributionsArtifactsAPI *DistributionsArtifactsAPIService

	DistributionsContainerAPI *DistributionsContainerAPIService

	DistributionsFileAPI *DistributionsFileAPIService

	DistributionsGemAPI *DistributionsGemAPIService

	DistributionsMavenAPI *DistributionsMavenAPIService

	DistributionsOstreeAPI *DistributionsOstreeAPIService

	DistributionsPypiAPI *DistributionsPypiAPIService

	DistributionsRpmAPI *DistributionsRpmAPIService

	DocsApiJsonAPI *DocsApiJsonAPIService

	DocsApiYamlAPI *DocsApiYamlAPIService

	DomainsAPI *DomainsAPIService

	ExportersFilesystemAPI *ExportersFilesystemAPIService

	ExportersFilesystemExportsAPI *ExportersFilesystemExportsAPIService

	ExportersPulpAPI *ExportersPulpAPIService

	ExportersPulpExportsAPI *ExportersPulpExportsAPIService

	GalaxyDetailAPI *GalaxyDetailAPIService

	GroupsAPI *GroupsAPIService

	GroupsRolesAPI *GroupsRolesAPIService

	GroupsUsersAPI *GroupsUsersAPIService

	ImportersPulpAPI *ImportersPulpAPIService

	ImportersPulpImportCheckAPI *ImportersPulpImportCheckAPIService

	ImportersPulpImportsAPI *ImportersPulpImportsAPIService

	OrphansAPI *OrphansAPIService

	OrphansCleanupAPI *OrphansCleanupAPIService

	PublicationsAPI *PublicationsAPIService

	PublicationsAptAPI *PublicationsAptAPIService

	PublicationsFileAPI *PublicationsFileAPIService

	PublicationsGemAPI *PublicationsGemAPIService

	PublicationsPypiAPI *PublicationsPypiAPIService

	PublicationsRpmAPI *PublicationsRpmAPIService

	PublicationsVerbatimAPI *PublicationsVerbatimAPIService

	PulpAnsibleApiAPI *PulpAnsibleApiAPIService

	PulpAnsibleApiV2CollectionsVersionsAPI *PulpAnsibleApiV2CollectionsVersionsAPIService

	PulpAnsibleApiV3API *PulpAnsibleApiV3APIService

	PulpAnsibleApiV3ArtifactsCollectionsAPI *PulpAnsibleApiV3ArtifactsCollectionsAPIService

	PulpAnsibleApiV3CollectionVersionsAllAPI *PulpAnsibleApiV3CollectionVersionsAllAPIService

	PulpAnsibleApiV3CollectionsAPI *PulpAnsibleApiV3CollectionsAPIService

	PulpAnsibleApiV3CollectionsAllAPI *PulpAnsibleApiV3CollectionsAllAPIService

	PulpAnsibleApiV3CollectionsVersionsAPI *PulpAnsibleApiV3CollectionsVersionsAPIService

	PulpAnsibleApiV3CollectionsVersionsDocsBlobAPI *PulpAnsibleApiV3CollectionsVersionsDocsBlobAPIService

	PulpAnsibleApiV3NamespacesAPI *PulpAnsibleApiV3NamespacesAPIService

	PulpAnsibleApiV3PluginAnsibleClientConfigurationAPI *PulpAnsibleApiV3PluginAnsibleClientConfigurationAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService

	PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI *PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPIService

	PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService

	PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI *PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPIService

	PulpAnsibleArtifactsCollectionsV3API *PulpAnsibleArtifactsCollectionsV3APIService

	PulpAnsibleDefaultApiAPI *PulpAnsibleDefaultApiAPIService

	PulpAnsibleDefaultApiV3API *PulpAnsibleDefaultApiV3APIService

	PulpAnsibleDefaultApiV3ArtifactsCollectionsAPI *PulpAnsibleDefaultApiV3ArtifactsCollectionsAPIService

	PulpAnsibleDefaultApiV3CollectionVersionsAllAPI *PulpAnsibleDefaultApiV3CollectionVersionsAllAPIService

	PulpAnsibleDefaultApiV3CollectionsAPI *PulpAnsibleDefaultApiV3CollectionsAPIService

	PulpAnsibleDefaultApiV3CollectionsAllAPI *PulpAnsibleDefaultApiV3CollectionsAllAPIService

	PulpAnsibleDefaultApiV3CollectionsVersionsAPI *PulpAnsibleDefaultApiV3CollectionsVersionsAPIService

	PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPI *PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPIService

	PulpAnsibleDefaultApiV3NamespacesAPI *PulpAnsibleDefaultApiV3NamespacesAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPI *PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI *PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPIService

	PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService

	PulpAnsibleTagsAPI *PulpAnsibleTagsAPIService

	PulpContainerNamespacesAPI *PulpContainerNamespacesAPIService

	PulpMavenAPI *PulpMavenAPIService

	PypiAPI *PypiAPIService

	PypiLegacyAPI *PypiLegacyAPIService

	PypiMetadataAPI *PypiMetadataAPIService

	PypiSimpleAPI *PypiSimpleAPIService

	RemotesAPI *RemotesAPIService

	RemotesAptAPI *RemotesAptAPIService

	RemotesCollectionAPI *RemotesCollectionAPIService

	RemotesContainerAPI *RemotesContainerAPIService

	RemotesFileAPI *RemotesFileAPIService

	RemotesGemAPI *RemotesGemAPIService

	RemotesGitAPI *RemotesGitAPIService

	RemotesMavenAPI *RemotesMavenAPIService

	RemotesOstreeAPI *RemotesOstreeAPIService

	RemotesPythonAPI *RemotesPythonAPIService

	RemotesRoleAPI *RemotesRoleAPIService

	RemotesRpmAPI *RemotesRpmAPIService

	RemotesUlnAPI *RemotesUlnAPIService

	RepairAPI *RepairAPIService

	RepositoriesAPI *RepositoriesAPIService

	RepositoriesAnsibleAPI *RepositoriesAnsibleAPIService

	RepositoriesAnsibleVersionsAPI *RepositoriesAnsibleVersionsAPIService

	RepositoriesAptAPI *RepositoriesAptAPIService

	RepositoriesAptVersionsAPI *RepositoriesAptVersionsAPIService

	RepositoriesContainerAPI *RepositoriesContainerAPIService

	RepositoriesContainerPushAPI *RepositoriesContainerPushAPIService

	RepositoriesContainerPushVersionsAPI *RepositoriesContainerPushVersionsAPIService

	RepositoriesContainerVersionsAPI *RepositoriesContainerVersionsAPIService

	RepositoriesFileAPI *RepositoriesFileAPIService

	RepositoriesFileVersionsAPI *RepositoriesFileVersionsAPIService

	RepositoriesGemAPI *RepositoriesGemAPIService

	RepositoriesGemVersionsAPI *RepositoriesGemVersionsAPIService

	RepositoriesMavenAPI *RepositoriesMavenAPIService

	RepositoriesMavenVersionsAPI *RepositoriesMavenVersionsAPIService

	RepositoriesOstreeAPI *RepositoriesOstreeAPIService

	RepositoriesOstreeVersionsAPI *RepositoriesOstreeVersionsAPIService

	RepositoriesPythonAPI *RepositoriesPythonAPIService

	RepositoriesPythonVersionsAPI *RepositoriesPythonVersionsAPIService

	RepositoriesReclaimSpaceAPI *RepositoriesReclaimSpaceAPIService

	RepositoriesRpmAPI *RepositoriesRpmAPIService

	RepositoriesRpmVersionsAPI *RepositoriesRpmVersionsAPIService

	RepositoryVersionsAPI *RepositoryVersionsAPIService

	RolesAPI *RolesAPIService

	RpmCompsAPI *RpmCompsAPIService

	RpmCopyAPI *RpmCopyAPIService

	SigningServicesAPI *SigningServicesAPIService

	StatusAPI *StatusAPIService

	TaskGroupsAPI *TaskGroupsAPIService

	TaskSchedulesAPI *TaskSchedulesAPIService

	TasksAPI *TasksAPIService

	TokenAPI *TokenAPIService

	UploadsAPI *UploadsAPIService

	UpstreamPulpsAPI *UpstreamPulpsAPIService

	UsersAPI *UsersAPIService

	UsersRolesAPI *UsersRolesAPIService

	VersionsAPI *VersionsAPIService

	WorkersAPI *WorkersAPIService
}

type service struct {
	client *APIClient
}

// NewAPIClient creates a new API client. Requires a userAgent string describing your application.
// optionally a custom http.Client to allow for advanced features such as caching.
func NewAPIClient(cfg *Configuration) *APIClient {
	if cfg.HTTPClient == nil {
		cfg.HTTPClient = http.DefaultClient
	}

	c := &APIClient{}
	c.cfg = cfg
	c.common.client = c

	// API Services
	c.AccessPoliciesAPI = (*AccessPoliciesAPIService)(&c.common)
	c.AcsFileAPI = (*AcsFileAPIService)(&c.common)
	c.AcsRpmAPI = (*AcsRpmAPIService)(&c.common)
	c.AnsibleCollectionsAPI = (*AnsibleCollectionsAPIService)(&c.common)
	c.AnsibleCopyAPI = (*AnsibleCopyAPIService)(&c.common)
	c.ApiCollectionsAPI = (*ApiCollectionsAPIService)(&c.common)
	c.ApiRolesAPI = (*ApiRolesAPIService)(&c.common)
	c.ArtifactsAPI = (*ArtifactsAPIService)(&c.common)
	c.CollectionImportAPI = (*CollectionImportAPIService)(&c.common)
	c.ContentAPI = (*ContentAPIService)(&c.common)
	c.ContentAdvisoriesAPI = (*ContentAdvisoriesAPIService)(&c.common)
	c.ContentArtifactAPI = (*ContentArtifactAPIService)(&c.common)
	c.ContentBlobsAPI = (*ContentBlobsAPIService)(&c.common)
	c.ContentCollectionDeprecationsAPI = (*ContentCollectionDeprecationsAPIService)(&c.common)
	c.ContentCollectionMarksAPI = (*ContentCollectionMarksAPIService)(&c.common)
	c.ContentCollectionSignaturesAPI = (*ContentCollectionSignaturesAPIService)(&c.common)
	c.ContentCollectionVersionsAPI = (*ContentCollectionVersionsAPIService)(&c.common)
	c.ContentCommitsAPI = (*ContentCommitsAPIService)(&c.common)
	c.ContentConfigsAPI = (*ContentConfigsAPIService)(&c.common)
	c.ContentContentAPI = (*ContentContentAPIService)(&c.common)
	c.ContentDistributionTreesAPI = (*ContentDistributionTreesAPIService)(&c.common)
	c.ContentFilesAPI = (*ContentFilesAPIService)(&c.common)
	c.ContentGemAPI = (*ContentGemAPIService)(&c.common)
	c.ContentGenericContentsAPI = (*ContentGenericContentsAPIService)(&c.common)
	c.ContentInstallerFileIndicesAPI = (*ContentInstallerFileIndicesAPIService)(&c.common)
	c.ContentInstallerPackagesAPI = (*ContentInstallerPackagesAPIService)(&c.common)
	c.ContentManifestsAPI = (*ContentManifestsAPIService)(&c.common)
	c.ContentModulemdDefaultsAPI = (*ContentModulemdDefaultsAPIService)(&c.common)
	c.ContentModulemdObsoletesAPI = (*ContentModulemdObsoletesAPIService)(&c.common)
	c.ContentModulemdsAPI = (*ContentModulemdsAPIService)(&c.common)
	c.ContentNamespacesAPI = (*ContentNamespacesAPIService)(&c.common)
	c.ContentObjectsAPI = (*ContentObjectsAPIService)(&c.common)
	c.ContentPackageIndicesAPI = (*ContentPackageIndicesAPIService)(&c.common)
	c.ContentPackageReleaseComponentsAPI = (*ContentPackageReleaseComponentsAPIService)(&c.common)
	c.ContentPackagecategoriesAPI = (*ContentPackagecategoriesAPIService)(&c.common)
	c.ContentPackageenvironmentsAPI = (*ContentPackageenvironmentsAPIService)(&c.common)
	c.ContentPackagegroupsAPI = (*ContentPackagegroupsAPIService)(&c.common)
	c.ContentPackagelangpacksAPI = (*ContentPackagelangpacksAPIService)(&c.common)
	c.ContentPackagesAPI = (*ContentPackagesAPIService)(&c.common)
	c.ContentRefsAPI = (*ContentRefsAPIService)(&c.common)
	c.ContentReleaseArchitecturesAPI = (*ContentReleaseArchitecturesAPIService)(&c.common)
	c.ContentReleaseComponentsAPI = (*ContentReleaseComponentsAPIService)(&c.common)
	c.ContentReleaseFilesAPI = (*ContentReleaseFilesAPIService)(&c.common)
	c.ContentReleasesAPI = (*ContentReleasesAPIService)(&c.common)
	c.ContentRepoMetadataFilesAPI = (*ContentRepoMetadataFilesAPIService)(&c.common)
	c.ContentRolesAPI = (*ContentRolesAPIService)(&c.common)
	c.ContentSignaturesAPI = (*ContentSignaturesAPIService)(&c.common)
	c.ContentSummariesAPI = (*ContentSummariesAPIService)(&c.common)
	c.ContentTagsAPI = (*ContentTagsAPIService)(&c.common)
	c.ContentguardsAPI = (*ContentguardsAPIService)(&c.common)
	c.ContentguardsContentRedirectAPI = (*ContentguardsContentRedirectAPIService)(&c.common)
	c.ContentguardsRbacAPI = (*ContentguardsRbacAPIService)(&c.common)
	c.ContentguardsRhsmAPI = (*ContentguardsRhsmAPIService)(&c.common)
	c.ContentguardsX509API = (*ContentguardsX509APIService)(&c.common)
	c.DebCopyAPI = (*DebCopyAPIService)(&c.common)
	c.DistributionsAPI = (*DistributionsAPIService)(&c.common)
	c.DistributionsAnsibleAPI = (*DistributionsAnsibleAPIService)(&c.common)
	c.DistributionsAptAPI = (*DistributionsAptAPIService)(&c.common)
	c.DistributionsArtifactsAPI = (*DistributionsArtifactsAPIService)(&c.common)
	c.DistributionsContainerAPI = (*DistributionsContainerAPIService)(&c.common)
	c.DistributionsFileAPI = (*DistributionsFileAPIService)(&c.common)
	c.DistributionsGemAPI = (*DistributionsGemAPIService)(&c.common)
	c.DistributionsMavenAPI = (*DistributionsMavenAPIService)(&c.common)
	c.DistributionsOstreeAPI = (*DistributionsOstreeAPIService)(&c.common)
	c.DistributionsPypiAPI = (*DistributionsPypiAPIService)(&c.common)
	c.DistributionsRpmAPI = (*DistributionsRpmAPIService)(&c.common)
	c.DocsApiJsonAPI = (*DocsApiJsonAPIService)(&c.common)
	c.DocsApiYamlAPI = (*DocsApiYamlAPIService)(&c.common)
	c.DomainsAPI = (*DomainsAPIService)(&c.common)
	c.ExportersFilesystemAPI = (*ExportersFilesystemAPIService)(&c.common)
	c.ExportersFilesystemExportsAPI = (*ExportersFilesystemExportsAPIService)(&c.common)
	c.ExportersPulpAPI = (*ExportersPulpAPIService)(&c.common)
	c.ExportersPulpExportsAPI = (*ExportersPulpExportsAPIService)(&c.common)
	c.GalaxyDetailAPI = (*GalaxyDetailAPIService)(&c.common)
	c.GroupsAPI = (*GroupsAPIService)(&c.common)
	c.GroupsRolesAPI = (*GroupsRolesAPIService)(&c.common)
	c.GroupsUsersAPI = (*GroupsUsersAPIService)(&c.common)
	c.ImportersPulpAPI = (*ImportersPulpAPIService)(&c.common)
	c.ImportersPulpImportCheckAPI = (*ImportersPulpImportCheckAPIService)(&c.common)
	c.ImportersPulpImportsAPI = (*ImportersPulpImportsAPIService)(&c.common)
	c.OrphansAPI = (*OrphansAPIService)(&c.common)
	c.OrphansCleanupAPI = (*OrphansCleanupAPIService)(&c.common)
	c.PublicationsAPI = (*PublicationsAPIService)(&c.common)
	c.PublicationsAptAPI = (*PublicationsAptAPIService)(&c.common)
	c.PublicationsFileAPI = (*PublicationsFileAPIService)(&c.common)
	c.PublicationsGemAPI = (*PublicationsGemAPIService)(&c.common)
	c.PublicationsPypiAPI = (*PublicationsPypiAPIService)(&c.common)
	c.PublicationsRpmAPI = (*PublicationsRpmAPIService)(&c.common)
	c.PublicationsVerbatimAPI = (*PublicationsVerbatimAPIService)(&c.common)
	c.PulpAnsibleApiAPI = (*PulpAnsibleApiAPIService)(&c.common)
	c.PulpAnsibleApiV2CollectionsVersionsAPI = (*PulpAnsibleApiV2CollectionsVersionsAPIService)(&c.common)
	c.PulpAnsibleApiV3API = (*PulpAnsibleApiV3APIService)(&c.common)
	c.PulpAnsibleApiV3ArtifactsCollectionsAPI = (*PulpAnsibleApiV3ArtifactsCollectionsAPIService)(&c.common)
	c.PulpAnsibleApiV3CollectionVersionsAllAPI = (*PulpAnsibleApiV3CollectionVersionsAllAPIService)(&c.common)
	c.PulpAnsibleApiV3CollectionsAPI = (*PulpAnsibleApiV3CollectionsAPIService)(&c.common)
	c.PulpAnsibleApiV3CollectionsAllAPI = (*PulpAnsibleApiV3CollectionsAllAPIService)(&c.common)
	c.PulpAnsibleApiV3CollectionsVersionsAPI = (*PulpAnsibleApiV3CollectionsVersionsAPIService)(&c.common)
	c.PulpAnsibleApiV3CollectionsVersionsDocsBlobAPI = (*PulpAnsibleApiV3CollectionsVersionsDocsBlobAPIService)(&c.common)
	c.PulpAnsibleApiV3NamespacesAPI = (*PulpAnsibleApiV3NamespacesAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleClientConfigurationAPI = (*PulpAnsibleApiV3PluginAnsibleClientConfigurationAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI = (*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI = (*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService)(&c.common)
	c.PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI = (*PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPIService)(&c.common)
	c.PulpAnsibleArtifactsCollectionsV3API = (*PulpAnsibleArtifactsCollectionsV3APIService)(&c.common)
	c.PulpAnsibleDefaultApiAPI = (*PulpAnsibleDefaultApiAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3API = (*PulpAnsibleDefaultApiV3APIService)(&c.common)
	c.PulpAnsibleDefaultApiV3ArtifactsCollectionsAPI = (*PulpAnsibleDefaultApiV3ArtifactsCollectionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3CollectionVersionsAllAPI = (*PulpAnsibleDefaultApiV3CollectionVersionsAllAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3CollectionsAPI = (*PulpAnsibleDefaultApiV3CollectionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3CollectionsAllAPI = (*PulpAnsibleDefaultApiV3CollectionsAllAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3CollectionsVersionsAPI = (*PulpAnsibleDefaultApiV3CollectionsVersionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPI = (*PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3NamespacesAPI = (*PulpAnsibleDefaultApiV3NamespacesAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPIService)(&c.common)
	c.PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI = (*PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService)(&c.common)
	c.PulpAnsibleTagsAPI = (*PulpAnsibleTagsAPIService)(&c.common)
	c.PulpContainerNamespacesAPI = (*PulpContainerNamespacesAPIService)(&c.common)
	c.PulpMavenAPI = (*PulpMavenAPIService)(&c.common)
	c.PypiAPI = (*PypiAPIService)(&c.common)
	c.PypiLegacyAPI = (*PypiLegacyAPIService)(&c.common)
	c.PypiMetadataAPI = (*PypiMetadataAPIService)(&c.common)
	c.PypiSimpleAPI = (*PypiSimpleAPIService)(&c.common)
	c.RemotesAPI = (*RemotesAPIService)(&c.common)
	c.RemotesAptAPI = (*RemotesAptAPIService)(&c.common)
	c.RemotesCollectionAPI = (*RemotesCollectionAPIService)(&c.common)
	c.RemotesContainerAPI = (*RemotesContainerAPIService)(&c.common)
	c.RemotesFileAPI = (*RemotesFileAPIService)(&c.common)
	c.RemotesGemAPI = (*RemotesGemAPIService)(&c.common)
	c.RemotesGitAPI = (*RemotesGitAPIService)(&c.common)
	c.RemotesMavenAPI = (*RemotesMavenAPIService)(&c.common)
	c.RemotesOstreeAPI = (*RemotesOstreeAPIService)(&c.common)
	c.RemotesPythonAPI = (*RemotesPythonAPIService)(&c.common)
	c.RemotesRoleAPI = (*RemotesRoleAPIService)(&c.common)
	c.RemotesRpmAPI = (*RemotesRpmAPIService)(&c.common)
	c.RemotesUlnAPI = (*RemotesUlnAPIService)(&c.common)
	c.RepairAPI = (*RepairAPIService)(&c.common)
	c.RepositoriesAPI = (*RepositoriesAPIService)(&c.common)
	c.RepositoriesAnsibleAPI = (*RepositoriesAnsibleAPIService)(&c.common)
	c.RepositoriesAnsibleVersionsAPI = (*RepositoriesAnsibleVersionsAPIService)(&c.common)
	c.RepositoriesAptAPI = (*RepositoriesAptAPIService)(&c.common)
	c.RepositoriesAptVersionsAPI = (*RepositoriesAptVersionsAPIService)(&c.common)
	c.RepositoriesContainerAPI = (*RepositoriesContainerAPIService)(&c.common)
	c.RepositoriesContainerPushAPI = (*RepositoriesContainerPushAPIService)(&c.common)
	c.RepositoriesContainerPushVersionsAPI = (*RepositoriesContainerPushVersionsAPIService)(&c.common)
	c.RepositoriesContainerVersionsAPI = (*RepositoriesContainerVersionsAPIService)(&c.common)
	c.RepositoriesFileAPI = (*RepositoriesFileAPIService)(&c.common)
	c.RepositoriesFileVersionsAPI = (*RepositoriesFileVersionsAPIService)(&c.common)
	c.RepositoriesGemAPI = (*RepositoriesGemAPIService)(&c.common)
	c.RepositoriesGemVersionsAPI = (*RepositoriesGemVersionsAPIService)(&c.common)
	c.RepositoriesMavenAPI = (*RepositoriesMavenAPIService)(&c.common)
	c.RepositoriesMavenVersionsAPI = (*RepositoriesMavenVersionsAPIService)(&c.common)
	c.RepositoriesOstreeAPI = (*RepositoriesOstreeAPIService)(&c.common)
	c.RepositoriesOstreeVersionsAPI = (*RepositoriesOstreeVersionsAPIService)(&c.common)
	c.RepositoriesPythonAPI = (*RepositoriesPythonAPIService)(&c.common)
	c.RepositoriesPythonVersionsAPI = (*RepositoriesPythonVersionsAPIService)(&c.common)
	c.RepositoriesReclaimSpaceAPI = (*RepositoriesReclaimSpaceAPIService)(&c.common)
	c.RepositoriesRpmAPI = (*RepositoriesRpmAPIService)(&c.common)
	c.RepositoriesRpmVersionsAPI = (*RepositoriesRpmVersionsAPIService)(&c.common)
	c.RepositoryVersionsAPI = (*RepositoryVersionsAPIService)(&c.common)
	c.RolesAPI = (*RolesAPIService)(&c.common)
	c.RpmCompsAPI = (*RpmCompsAPIService)(&c.common)
	c.RpmCopyAPI = (*RpmCopyAPIService)(&c.common)
	c.SigningServicesAPI = (*SigningServicesAPIService)(&c.common)
	c.StatusAPI = (*StatusAPIService)(&c.common)
	c.TaskGroupsAPI = (*TaskGroupsAPIService)(&c.common)
	c.TaskSchedulesAPI = (*TaskSchedulesAPIService)(&c.common)
	c.TasksAPI = (*TasksAPIService)(&c.common)
	c.TokenAPI = (*TokenAPIService)(&c.common)
	c.UploadsAPI = (*UploadsAPIService)(&c.common)
	c.UpstreamPulpsAPI = (*UpstreamPulpsAPIService)(&c.common)
	c.UsersAPI = (*UsersAPIService)(&c.common)
	c.UsersRolesAPI = (*UsersRolesAPIService)(&c.common)
	c.VersionsAPI = (*VersionsAPIService)(&c.common)
	c.WorkersAPI = (*WorkersAPIService)(&c.common)

	return c
}

func atoi(in string) (int, error) {
	return strconv.Atoi(in)
}

// selectHeaderContentType select a content type from the available list.
func selectHeaderContentType(contentTypes []string) string {
	if len(contentTypes) == 0 {
		return ""
	}
	if contains(contentTypes, "application/json") {
		return "application/json"
	}
	return contentTypes[0] // use the first content type specified in 'consumes'
}

// selectHeaderAccept join all accept types and return
func selectHeaderAccept(accepts []string) string {
	if len(accepts) == 0 {
		return ""
	}

	if contains(accepts, "application/json") {
		return "application/json"
	}

	return strings.Join(accepts, ",")
}

// contains is a case insensitive match, finding needle in a haystack
func contains(haystack []string, needle string) bool {
	for _, a := range haystack {
		if strings.EqualFold(a, needle) {
			return true
		}
	}
	return false
}

// Verify optional parameters are of the correct type.
func typeCheckParameter(obj interface{}, expected string, name string) error {
	// Make sure there is an object.
	if obj == nil {
		return nil
	}

	// Check the type is as expected.
	if reflect.TypeOf(obj).String() != expected {
		return fmt.Errorf("expected %s to be of type %s but received %s", name, expected, reflect.TypeOf(obj).String())
	}
	return nil
}

func parameterValueToString( obj interface{}, key string ) string {
	if reflect.TypeOf(obj).Kind() != reflect.Ptr {
		return fmt.Sprintf("%v", obj)
	}
	var param,ok = obj.(MappedNullable)
	if !ok {
		return ""
	}
	dataMap,err := param.ToMap()
	if err != nil {
		return ""
	}
	return fmt.Sprintf("%v", dataMap[key])
}

// parameterAddToHeaderOrQuery adds the provided object to the request header or url query
// supporting deep object syntax
func parameterAddToHeaderOrQuery(headerOrQueryParams interface{}, keyPrefix string, obj interface{}, collectionType string) {
	var v = reflect.ValueOf(obj)
	var value = ""
	if v == reflect.ValueOf(nil) {
		value = "null"
	} else {
		switch v.Kind() {
			case reflect.Invalid:
				value = "invalid"

			case reflect.Struct:
				if t,ok := obj.(MappedNullable); ok {
					dataMap,err := t.ToMap()
					if err != nil {
						return
					}
					parameterAddToHeaderOrQuery(headerOrQueryParams, keyPrefix, dataMap, collectionType)
					return
				}
				if t, ok := obj.(time.Time); ok {
					parameterAddToHeaderOrQuery(headerOrQueryParams, keyPrefix, t.Format(time.RFC3339), collectionType)
					return
				}
				value = v.Type().String() + " value"
			case reflect.Slice:
				var indValue = reflect.ValueOf(obj)
				if indValue == reflect.ValueOf(nil) {
					return
				}
				var lenIndValue = indValue.Len()
				for i:=0;i<lenIndValue;i++ {
					var arrayValue = indValue.Index(i)
					parameterAddToHeaderOrQuery(headerOrQueryParams, keyPrefix, arrayValue.Interface(), collectionType)
				}
				return

			case reflect.Map:
				var indValue = reflect.ValueOf(obj)
				if indValue == reflect.ValueOf(nil) {
					return
				}
				iter := indValue.MapRange()
				for iter.Next() {
					k,v := iter.Key(), iter.Value()
					parameterAddToHeaderOrQuery(headerOrQueryParams, fmt.Sprintf("%s[%s]", keyPrefix, k.String()), v.Interface(), collectionType)
				}
				return

			case reflect.Interface:
				fallthrough
			case reflect.Ptr:
				parameterAddToHeaderOrQuery(headerOrQueryParams, keyPrefix, v.Elem().Interface(), collectionType)
				return

			case reflect.Int, reflect.Int8, reflect.Int16,
				reflect.Int32, reflect.Int64:
				value = strconv.FormatInt(v.Int(), 10)
			case reflect.Uint, reflect.Uint8, reflect.Uint16,
				reflect.Uint32, reflect.Uint64, reflect.Uintptr:
				value = strconv.FormatUint(v.Uint(), 10)
			case reflect.Float32, reflect.Float64:
				value = strconv.FormatFloat(v.Float(), 'g', -1, 32)
			case reflect.Bool:
				value = strconv.FormatBool(v.Bool())
			case reflect.String:
				value = v.String()
			default:
				value = v.Type().String() + " value"
		}
	}

	switch valuesMap := headerOrQueryParams.(type) {
		case url.Values:
			if collectionType == "csv" && valuesMap.Get(keyPrefix) != "" {
				valuesMap.Set(keyPrefix, valuesMap.Get(keyPrefix) + "," + value)
			} else {
				valuesMap.Add(keyPrefix, value)
			}
			break
		case map[string]string:
			valuesMap[keyPrefix] = value
			break
	}
}

// helper for converting interface{} parameters to json strings
func parameterToJson(obj interface{}) (string, error) {
	jsonBuf, err := json.Marshal(obj)
	if err != nil {
		return "", err
	}
	return string(jsonBuf), err
}

// callAPI do the request.
func (c *APIClient) callAPI(request *http.Request) (*http.Response, error) {
	if c.cfg.Debug {
		dump, err := httputil.DumpRequestOut(request, true)
		if err != nil {
			return nil, err
		}
		log.Printf("\n%s\n", string(dump))
	}

	resp, err := c.cfg.HTTPClient.Do(request)
	if err != nil {
		return resp, err
	}

	if c.cfg.Debug {
		dump, err := httputil.DumpResponse(resp, true)
		if err != nil {
			return resp, err
		}
		log.Printf("\n%s\n", string(dump))
	}
	return resp, err
}

// Allow modification of underlying config for alternate implementations and testing
// Caution: modifying the configuration while live can cause data races and potentially unwanted behavior
func (c *APIClient) GetConfig() *Configuration {
	return c.cfg
}

type formFile struct {
		fileBytes []byte
		fileName string
		formFileName string
}

// prepareRequest build the request
func (c *APIClient) prepareRequest(
	ctx context.Context,
	path string, method string,
	postBody interface{},
	headerParams map[string]string,
	queryParams url.Values,
	formParams url.Values,
	formFiles []formFile) (localVarRequest *http.Request, err error) {

	var body *bytes.Buffer

	// Detect postBody type and post.
	if postBody != nil {
		contentType := headerParams["Content-Type"]
		if contentType == "" {
			contentType = detectContentType(postBody)
			headerParams["Content-Type"] = contentType
		}

		body, err = setBody(postBody, contentType)
		if err != nil {
			return nil, err
		}
	}

	// add form parameters and file if available.
	if strings.HasPrefix(headerParams["Content-Type"], "multipart/form-data") && len(formParams) > 0 || (len(formFiles) > 0) {
		if body != nil {
			return nil, errors.New("Cannot specify postBody and multipart form at the same time.")
		}
		body = &bytes.Buffer{}
		w := multipart.NewWriter(body)

		for k, v := range formParams {
			for _, iv := range v {
				if strings.HasPrefix(k, "@") { // file
					err = addFile(w, k[1:], iv)
					if err != nil {
						return nil, err
					}
				} else { // form value
					w.WriteField(k, iv)
				}
			}
		}
		for _, formFile := range formFiles {
			if len(formFile.fileBytes) > 0 && formFile.fileName != "" {
				w.Boundary()
				part, err := w.CreateFormFile(formFile.formFileName, filepath.Base(formFile.fileName))
				if err != nil {
						return nil, err
				}
				_, err = part.Write(formFile.fileBytes)
				if err != nil {
						return nil, err
				}
			}
		}

		// Set the Boundary in the Content-Type
		headerParams["Content-Type"] = w.FormDataContentType()

		// Set Content-Length
		headerParams["Content-Length"] = fmt.Sprintf("%d", body.Len())
		w.Close()
	}

	if strings.HasPrefix(headerParams["Content-Type"], "application/x-www-form-urlencoded") && len(formParams) > 0 {
		if body != nil {
			return nil, errors.New("Cannot specify postBody and x-www-form-urlencoded form at the same time.")
		}
		body = &bytes.Buffer{}
		body.WriteString(formParams.Encode())
		// Set Content-Length
		headerParams["Content-Length"] = fmt.Sprintf("%d", body.Len())
	}

	// Setup path and query parameters
	url, err := url.Parse(path)
	if err != nil {
		return nil, err
	}

	// Override request host, if applicable
	if c.cfg.Host != "" {
		url.Host = c.cfg.Host
	}

	// Override request scheme, if applicable
	if c.cfg.Scheme != "" {
		url.Scheme = c.cfg.Scheme
	}

	// Adding Query Param
	query := url.Query()
	for k, v := range queryParams {
		for _, iv := range v {
			query.Add(k, iv)
		}
	}

	// Encode the parameters.
	url.RawQuery = queryParamSplit.ReplaceAllStringFunc(query.Encode(), func(s string) string {
		pieces := strings.Split(s, "=")
		pieces[0] = queryDescape.Replace(pieces[0])
		return strings.Join(pieces, "=")
	})

	// Generate a new request
	if body != nil {
		localVarRequest, err = http.NewRequest(method, url.String(), body)
	} else {
		localVarRequest, err = http.NewRequest(method, url.String(), nil)
	}
	if err != nil {
		return nil, err
	}

	// add header parameters, if any
	if len(headerParams) > 0 {
		headers := http.Header{}
		for h, v := range headerParams {
			headers[h] = []string{v}
		}
		localVarRequest.Header = headers
	}

	// Add the user agent to the request.
	localVarRequest.Header.Add("User-Agent", c.cfg.UserAgent)

	if ctx != nil {
		// add context to the request
		localVarRequest = localVarRequest.WithContext(ctx)

		// Walk through any authentication.

		// Basic HTTP Authentication
		if auth, ok := ctx.Value(ContextBasicAuth).(BasicAuth); ok {
			localVarRequest.SetBasicAuth(auth.UserName, auth.Password)
		}

	}

	for header, value := range c.cfg.DefaultHeader {
		localVarRequest.Header.Add(header, value)
	}
	return localVarRequest, nil
}

func (c *APIClient) decode(v interface{}, b []byte, contentType string) (err error) {
	if len(b) == 0 {
		return nil
	}
	if s, ok := v.(*string); ok {
		*s = string(b)
		return nil
	}
	if f, ok := v.(*os.File); ok {
		f, err = os.CreateTemp("", "HttpClientFile")
		if err != nil {
			return
		}
		_, err = f.Write(b)
		if err != nil {
			return
		}
		_, err = f.Seek(0, io.SeekStart)
		return
	}
	if f, ok := v.(**os.File); ok {
		*f, err = os.CreateTemp("", "HttpClientFile")
		if err != nil {
			return
		}
		_, err = (*f).Write(b)
		if err != nil {
			return
		}
		_, err = (*f).Seek(0, io.SeekStart)
		return
	}
	if xmlCheck.MatchString(contentType) {
		if err = xml.Unmarshal(b, v); err != nil {
			return err
		}
		return nil
	}
	if jsonCheck.MatchString(contentType) {
		if actualObj, ok := v.(interface{ GetActualInstance() interface{} }); ok { // oneOf, anyOf schemas
			if unmarshalObj, ok := actualObj.(interface{ UnmarshalJSON([]byte) error }); ok { // make sure it has UnmarshalJSON defined
				if err = unmarshalObj.UnmarshalJSON(b); err != nil {
					return err
				}
			} else {
				return errors.New("Unknown type with GetActualInstance but no unmarshalObj.UnmarshalJSON defined")
			}
		} else if err = json.Unmarshal(b, v); err != nil { // simple model
			return err
		}
		return nil
	}
	return errors.New("undefined response type")
}

// Add a file to the multipart request
func addFile(w *multipart.Writer, fieldName, path string) error {
	file, err := os.Open(filepath.Clean(path))
	if err != nil {
		return err
	}
	err = file.Close()
	if err != nil {
		return err
	}

	part, err := w.CreateFormFile(fieldName, filepath.Base(path))
	if err != nil {
		return err
	}
	_, err = io.Copy(part, file)

	return err
}

// Prevent trying to import "fmt"
func reportError(format string, a ...interface{}) error {
	return fmt.Errorf(format, a...)
}

// A wrapper for strict JSON decoding
func newStrictDecoder(data []byte) *json.Decoder {
	dec := json.NewDecoder(bytes.NewBuffer(data))
	dec.DisallowUnknownFields()
	return dec
}

// Set request body from an interface{}
func setBody(body interface{}, contentType string) (bodyBuf *bytes.Buffer, err error) {
	if bodyBuf == nil {
		bodyBuf = &bytes.Buffer{}
	}

	if reader, ok := body.(io.Reader); ok {
		_, err = bodyBuf.ReadFrom(reader)
	} else if fp, ok := body.(*os.File); ok {
		_, err = bodyBuf.ReadFrom(fp)
	} else if b, ok := body.([]byte); ok {
		_, err = bodyBuf.Write(b)
	} else if s, ok := body.(string); ok {
		_, err = bodyBuf.WriteString(s)
	} else if s, ok := body.(*string); ok {
		_, err = bodyBuf.WriteString(*s)
	} else if jsonCheck.MatchString(contentType) {
		err = json.NewEncoder(bodyBuf).Encode(body)
	} else if xmlCheck.MatchString(contentType) {
		var bs []byte
		bs, err = xml.Marshal(body)
		if err == nil {
			bodyBuf.Write(bs)
		}
	}

	if err != nil {
		return nil, err
	}

	if bodyBuf.Len() == 0 {
		err = fmt.Errorf("invalid body type %s\n", contentType)
		return nil, err
	}
	return bodyBuf, nil
}

// detectContentType method is used to figure out `Request.Body` content type for request header
func detectContentType(body interface{}) string {
	contentType := "text/plain; charset=utf-8"
	kind := reflect.TypeOf(body).Kind()

	switch kind {
	case reflect.Struct, reflect.Map, reflect.Ptr:
		contentType = "application/json; charset=utf-8"
	case reflect.String:
		contentType = "text/plain; charset=utf-8"
	default:
		if b, ok := body.([]byte); ok {
			contentType = http.DetectContentType(b)
		} else if kind == reflect.Slice {
			contentType = "application/json; charset=utf-8"
		}
	}

	return contentType
}

// Ripped from https://github.com/gregjones/httpcache/blob/master/httpcache.go
type cacheControl map[string]string

func parseCacheControl(headers http.Header) cacheControl {
	cc := cacheControl{}
	ccHeader := headers.Get("Cache-Control")
	for _, part := range strings.Split(ccHeader, ",") {
		part = strings.Trim(part, " ")
		if part == "" {
			continue
		}
		if strings.ContainsRune(part, '=') {
			keyval := strings.Split(part, "=")
			cc[strings.Trim(keyval[0], " ")] = strings.Trim(keyval[1], ",")
		} else {
			cc[part] = ""
		}
	}
	return cc
}

// CacheExpires helper function to determine remaining time before repeating a request.
func CacheExpires(r *http.Response) time.Time {
	// Figure out when the cache expires.
	var expires time.Time
	now, err := time.Parse(time.RFC1123, r.Header.Get("date"))
	if err != nil {
		return time.Now()
	}
	respCacheControl := parseCacheControl(r.Header)

	if maxAge, ok := respCacheControl["max-age"]; ok {
		lifetime, err := time.ParseDuration(maxAge + "s")
		if err != nil {
			expires = now
		} else {
			expires = now.Add(lifetime)
		}
	} else {
		expiresHeader := r.Header.Get("Expires")
		if expiresHeader != "" {
			expires, err = time.Parse(time.RFC1123, expiresHeader)
			if err != nil {
				expires = now
			}
		}
	}
	return expires
}

func strlen(s string) int {
	return utf8.RuneCountInString(s)
}

// GenericOpenAPIError Provides access to the body, error and model on returned errors.
type GenericOpenAPIError struct {
	body  []byte
	error string
	model interface{}
}

// Error returns non-empty string if there was an error.
func (e GenericOpenAPIError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e GenericOpenAPIError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e GenericOpenAPIError) Model() interface{} {
	return e.model
}

// format error message using title and detail when model implements rfc7807
func formatErrorMessage(status string, v interface{}) string {
	str := ""
	metaValue := reflect.ValueOf(v).Elem()

	if metaValue.Kind() == reflect.Struct {
		field := metaValue.FieldByName("Title")
		if field != (reflect.Value{}) {
			str = fmt.Sprintf("%s", field.Interface())
		}

		field = metaValue.FieldByName("Detail")
		if field != (reflect.Value{}) {
			str = fmt.Sprintf("%s (%s)", str, field.Interface())
		}
	}

	return strings.TrimSpace(fmt.Sprintf("%s %s", status, str))
}
