/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the AccessPolicyResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AccessPolicyResponse{}

// AccessPolicyResponse Serializer for AccessPolicy.
type AccessPolicyResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// List of callables that define the new permissions to be created for new objects.This is deprecated. Use `creation_hooks` instead.
	PermissionsAssignment []map[string]interface{} `json:"permissions_assignment,omitempty"`
	// List of callables that may associate user roles for new objects.
	CreationHooks []map[string]interface{} `json:"creation_hooks,omitempty"`
	// List of policy statements defining the policy.
	Statements []map[string]interface{} `json:"statements"`
	// The name of ViewSet this AccessPolicy authorizes.
	ViewsetName *string `json:"viewset_name,omitempty"`
	// True if the AccessPolicy has been user-modified. False otherwise.
	Customized *bool `json:"customized,omitempty"`
	// A callable for performing queryset scoping. See plugin documentation for valid callables. Set to blank to turn off queryset scoping.
	QuerysetScoping map[string]interface{} `json:"queryset_scoping,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _AccessPolicyResponse AccessPolicyResponse

// NewAccessPolicyResponse instantiates a new AccessPolicyResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAccessPolicyResponse(statements []map[string]interface{}) *AccessPolicyResponse {
	this := AccessPolicyResponse{}
	this.Statements = statements
	return &this
}

// NewAccessPolicyResponseWithDefaults instantiates a new AccessPolicyResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAccessPolicyResponseWithDefaults() *AccessPolicyResponse {
	this := AccessPolicyResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *AccessPolicyResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *AccessPolicyResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetPermissionsAssignment returns the PermissionsAssignment field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetPermissionsAssignment() []map[string]interface{} {
	if o == nil || IsNil(o.PermissionsAssignment) {
		var ret []map[string]interface{}
		return ret
	}
	return o.PermissionsAssignment
}

// GetPermissionsAssignmentOk returns a tuple with the PermissionsAssignment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetPermissionsAssignmentOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.PermissionsAssignment) {
		return nil, false
	}
	return o.PermissionsAssignment, true
}

// HasPermissionsAssignment returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasPermissionsAssignment() bool {
	if o != nil && !IsNil(o.PermissionsAssignment) {
		return true
	}

	return false
}

// SetPermissionsAssignment gets a reference to the given []map[string]interface{} and assigns it to the PermissionsAssignment field.
func (o *AccessPolicyResponse) SetPermissionsAssignment(v []map[string]interface{}) {
	o.PermissionsAssignment = v
}

// GetCreationHooks returns the CreationHooks field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetCreationHooks() []map[string]interface{} {
	if o == nil || IsNil(o.CreationHooks) {
		var ret []map[string]interface{}
		return ret
	}
	return o.CreationHooks
}

// GetCreationHooksOk returns a tuple with the CreationHooks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetCreationHooksOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.CreationHooks) {
		return nil, false
	}
	return o.CreationHooks, true
}

// HasCreationHooks returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasCreationHooks() bool {
	if o != nil && !IsNil(o.CreationHooks) {
		return true
	}

	return false
}

// SetCreationHooks gets a reference to the given []map[string]interface{} and assigns it to the CreationHooks field.
func (o *AccessPolicyResponse) SetCreationHooks(v []map[string]interface{}) {
	o.CreationHooks = v
}

// GetStatements returns the Statements field value
func (o *AccessPolicyResponse) GetStatements() []map[string]interface{} {
	if o == nil {
		var ret []map[string]interface{}
		return ret
	}

	return o.Statements
}

// GetStatementsOk returns a tuple with the Statements field value
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetStatementsOk() ([]map[string]interface{}, bool) {
	if o == nil {
		return nil, false
	}
	return o.Statements, true
}

// SetStatements sets field value
func (o *AccessPolicyResponse) SetStatements(v []map[string]interface{}) {
	o.Statements = v
}

// GetViewsetName returns the ViewsetName field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetViewsetName() string {
	if o == nil || IsNil(o.ViewsetName) {
		var ret string
		return ret
	}
	return *o.ViewsetName
}

// GetViewsetNameOk returns a tuple with the ViewsetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetViewsetNameOk() (*string, bool) {
	if o == nil || IsNil(o.ViewsetName) {
		return nil, false
	}
	return o.ViewsetName, true
}

// HasViewsetName returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasViewsetName() bool {
	if o != nil && !IsNil(o.ViewsetName) {
		return true
	}

	return false
}

// SetViewsetName gets a reference to the given string and assigns it to the ViewsetName field.
func (o *AccessPolicyResponse) SetViewsetName(v string) {
	o.ViewsetName = &v
}

// GetCustomized returns the Customized field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetCustomized() bool {
	if o == nil || IsNil(o.Customized) {
		var ret bool
		return ret
	}
	return *o.Customized
}

// GetCustomizedOk returns a tuple with the Customized field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetCustomizedOk() (*bool, bool) {
	if o == nil || IsNil(o.Customized) {
		return nil, false
	}
	return o.Customized, true
}

// HasCustomized returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasCustomized() bool {
	if o != nil && !IsNil(o.Customized) {
		return true
	}

	return false
}

// SetCustomized gets a reference to the given bool and assigns it to the Customized field.
func (o *AccessPolicyResponse) SetCustomized(v bool) {
	o.Customized = &v
}

// GetQuerysetScoping returns the QuerysetScoping field value if set, zero value otherwise.
func (o *AccessPolicyResponse) GetQuerysetScoping() map[string]interface{} {
	if o == nil || IsNil(o.QuerysetScoping) {
		var ret map[string]interface{}
		return ret
	}
	return o.QuerysetScoping
}

// GetQuerysetScopingOk returns a tuple with the QuerysetScoping field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccessPolicyResponse) GetQuerysetScopingOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.QuerysetScoping) {
		return map[string]interface{}{}, false
	}
	return o.QuerysetScoping, true
}

// HasQuerysetScoping returns a boolean if a field has been set.
func (o *AccessPolicyResponse) HasQuerysetScoping() bool {
	if o != nil && !IsNil(o.QuerysetScoping) {
		return true
	}

	return false
}

// SetQuerysetScoping gets a reference to the given map[string]interface{} and assigns it to the QuerysetScoping field.
func (o *AccessPolicyResponse) SetQuerysetScoping(v map[string]interface{}) {
	o.QuerysetScoping = v
}

func (o AccessPolicyResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AccessPolicyResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.PermissionsAssignment) {
		toSerialize["permissions_assignment"] = o.PermissionsAssignment
	}
	if !IsNil(o.CreationHooks) {
		toSerialize["creation_hooks"] = o.CreationHooks
	}
	toSerialize["statements"] = o.Statements
	if !IsNil(o.ViewsetName) {
		toSerialize["viewset_name"] = o.ViewsetName
	}
	if !IsNil(o.Customized) {
		toSerialize["customized"] = o.Customized
	}
	if !IsNil(o.QuerysetScoping) {
		toSerialize["queryset_scoping"] = o.QuerysetScoping
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AccessPolicyResponse) UnmarshalJSON(bytes []byte) (err error) {
	varAccessPolicyResponse := _AccessPolicyResponse{}

	if err = json.Unmarshal(bytes, &varAccessPolicyResponse); err == nil {
		*o = AccessPolicyResponse(varAccessPolicyResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "permissions_assignment")
		delete(additionalProperties, "creation_hooks")
		delete(additionalProperties, "statements")
		delete(additionalProperties, "viewset_name")
		delete(additionalProperties, "customized")
		delete(additionalProperties, "queryset_scoping")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAccessPolicyResponse struct {
	value *AccessPolicyResponse
	isSet bool
}

func (v NullableAccessPolicyResponse) Get() *AccessPolicyResponse {
	return v.value
}

func (v *NullableAccessPolicyResponse) Set(val *AccessPolicyResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableAccessPolicyResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableAccessPolicyResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAccessPolicyResponse(val *AccessPolicyResponse) *NullableAccessPolicyResponse {
	return &NullableAccessPolicyResponse{value: val, isSet: true}
}

func (v NullableAccessPolicyResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAccessPolicyResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


