/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the GemGemContent type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &GemGemContent{}

// GemGemContent A Serializer for GemContent.
type GemGemContent struct {
	// A URI of a repository the new content unit should be associated with.
	Repository *string `json:"repository,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// An uploaded file that should be turned into the artifact of the content unit.
	File **os.File `json:"file,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _GemGemContent GemGemContent

// NewGemGemContent instantiates a new GemGemContent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGemGemContent() *GemGemContent {
	this := GemGemContent{}
	return &this
}

// NewGemGemContentWithDefaults instantiates a new GemGemContent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGemGemContentWithDefaults() *GemGemContent {
	this := GemGemContent{}
	return &this
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *GemGemContent) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GemGemContent) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *GemGemContent) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *GemGemContent) SetRepository(v string) {
	o.Repository = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *GemGemContent) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GemGemContent) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *GemGemContent) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *GemGemContent) SetArtifact(v string) {
	o.Artifact = &v
}

// GetFile returns the File field value if set, zero value otherwise.
func (o *GemGemContent) GetFile() *os.File {
	if o == nil || IsNil(o.File) {
		var ret *os.File
		return ret
	}
	return *o.File
}

// GetFileOk returns a tuple with the File field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GemGemContent) GetFileOk() (**os.File, bool) {
	if o == nil || IsNil(o.File) {
		return nil, false
	}
	return o.File, true
}

// HasFile returns a boolean if a field has been set.
func (o *GemGemContent) HasFile() bool {
	if o != nil && !IsNil(o.File) {
		return true
	}

	return false
}

// SetFile gets a reference to the given *os.File and assigns it to the File field.
func (o *GemGemContent) SetFile(v *os.File) {
	o.File = &v
}

func (o GemGemContent) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o GemGemContent) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.File) {
		toSerialize["file"] = o.File
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *GemGemContent) UnmarshalJSON(bytes []byte) (err error) {
	varGemGemContent := _GemGemContent{}

	if err = json.Unmarshal(bytes, &varGemGemContent); err == nil {
		*o = GemGemContent(varGemGemContent)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "file")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableGemGemContent struct {
	value *GemGemContent
	isSet bool
}

func (v NullableGemGemContent) Get() *GemGemContent {
	return v.value
}

func (v *NullableGemGemContent) Set(val *GemGemContent) {
	v.value = val
	v.isSet = true
}

func (v NullableGemGemContent) IsSet() bool {
	return v.isSet
}

func (v *NullableGemGemContent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGemGemContent(val *GemGemContent) *NullableGemGemContent {
	return &NullableGemGemContent{value: val, isSet: true}
}

func (v NullableGemGemContent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGemGemContent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


