/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import com.netscape.certsrv.account.Account;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.rest.AccountService;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSAccountService
extends AccountService {
    public static Logger logger = LoggerFactory.getLogger(TPSAccountService.class);
    TPSEngine engine = TPSEngine.getInstance();
    TPSEngineConfig configStore = this.engine.getConfig();

    public Account createAccount() {
        Account account = super.createAccount();
        try {
            String values;
            HashSet<String> components = new HashSet<String>();
            Collection roles = account.getRoles();
            if (roles.contains("Administrators")) {
                values = this.configStore.getString("target.configure.list", "");
                if (!StringUtils.isEmpty((CharSequence)values)) {
                    components.addAll(Arrays.asList(values.split(",")));
                }
                components.add("Generals");
                components.add("Audit_Logging");
            }
            if (roles.contains("TPS Agents") && !StringUtils.isEmpty((CharSequence)(values = this.configStore.getString("target.agent_approve.list", "")))) {
                components.addAll(Arrays.asList(values.split(",")));
            }
            account.setAttribute("components", StringUtils.join(components, (String)","));
        }
        catch (EBaseException e) {
            logger.error("TPSAccountService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
        return account;
    }
}

