/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.channel;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.CharConversionException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.tps.main.TPSBuffer;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.SymmetricKeyDeriver;
import org.mozilla.jss.crypto.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelProtocol {
    public static Logger logger = LoggerFactory.getLogger(SecureChannelProtocol.class);
    static String sharedSecretKeyName = null;
    static String masterKeyPrefix = null;
    static final int DEF_AES_KEYLENGTH = 16;
    static final int KEYLENGTH = 16;
    static final int PREFIXLENGHT = 128;
    static final int DES2_LENGTH = 16;
    static final int DES3_LENGTH = 24;
    static final int EIGHT_BYTES = 8;
    static final int KEYNAMELENGTH = 135;
    static final String TRANSPORT_KEY_NAME = "sharedSecret";
    static final String DEFKEYSET_NAME = "defKeySet";
    static int protocol = 1;
    public static final String encType = "enc";
    public static final String macType = "mac";
    public static final String kekType = "kek";
    public static final String authType = "auth";
    public static final String dekType = "dek";
    public static final String rmacType = "rmac";
    public static final int PROTOCOL_ONE = 1;
    public static final int PROTOCOL_TWO = 2;
    public static final int PROTOCOL_THREE = 3;
    public static final int HOST_CRYPTOGRAM = 0;
    public static final int CARD_CRYPTOGRAM = 1;
    static final int LONG_SIZE = 8;
    static final int AES_128_BYTES = 16;
    static final int AES_192_BYTES = 24;
    static final int AES_256_BYTES = 32;
    static final int AES_128_BITS = 128;
    static final int AES_192_BITS = 192;
    static final int AES_256_BITS = 256;
    private static final byte AES_CMAC_CONSTANT = -121;
    private static final int AES_CMAC_BLOCK_SIZE = 16;
    public static final byte CARD_CRYPTO_KDF_CONSTANT_SCP03 = 0;
    public static final byte HOST_CRYPTO_KDF_CONSTANT_SCP03 = 1;
    static final int[] parityTable = new int[]{1, 2, 4, 7, 8, 11, 13, 14, 16, 19, 21, 22, 25, 26, 28, 31, 32, 35, 37, 38, 41, 42, 44, 47, 49, 50, 52, 55, 56, 59, 61, 62, 64, 67, 69, 70, 73, 74, 76, 79, 81, 82, 84, 87, 88, 91, 93, 94, 97, 98, 100, 103, 104, 107, 109, 110, 112, 115, 117, 118, 121, 122, 124, 127, 128, 131, 133, 134, 137, 138, 140, 143, 145, 146, 148, 151, 152, 155, 157, 158, 161, 162, 164, 167, 168, 171, 173, 174, 176, 179, 181, 182, 185, 186, 188, 191, 193, 194, 196, 199, 200, 203, 205, 206, 208, 211, 213, 214, 217, 218, 220, 223, 224, 227, 229, 230, 233, 234, 236, 239, 241, 242, 244, 247, 248, 251, 253, 254};
    private SymmetricKey transportKey = null;
    CryptoManager cryptoManager = null;
    protected static final char[] hex = "0123456789abcdef".toCharArray();

    public SecureChannelProtocol() {
    }

    public SecureChannelProtocol(int theProtocol) {
        protocol = theProtocol;
    }

    public int getProtocol() {
        return protocol;
    }

    public SymmetricKey getSharedSecretKey(CryptoToken token) throws EBaseException {
        String method = "SecureChannelProtocol.getSharedSecretKey:";
        logger.debug(method + "entering: transportKey: " + this.transportKey);
        CryptoToken finalToken = token;
        CryptoToken internalToken = null;
        if (token == null) {
            logger.debug(method + " No token provided assume internal ");
            CryptoManager cm = null;
            try {
                cm = CryptoManager.getInstance();
                finalToken = internalToken = this.returnTokenByName("internal", cm);
            }
            catch (NotInitializedException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
            catch (NoSuchTokenException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
        }
        if (this.transportKey == null) {
            this.transportKey = SecureChannelProtocol.getSymKeyByName(finalToken, sharedSecretKeyName);
        }
        if (this.transportKey == null) {
            throw new EBaseException(method + "Can't locate shared secret key in token db.");
        }
        return this.transportKey;
    }

    public static String getSharedSecretKeyName(String name) throws EBaseException {
        String method = "SecureChannelProtocol.getSharedSecretKeyName:";
        logger.debug(method + " Entering...");
        if (name != null) {
            sharedSecretKeyName = name;
        }
        if (sharedSecretKeyName == null) {
            throw new EBaseException(method + " Can not find shared secret key name!");
        }
        return sharedSecretKeyName;
    }

    public static String setSharedSecretKeyName(String name) throws EBaseException {
        return SecureChannelProtocol.getSharedSecretKeyName(name);
    }

    public SymmetricKey returnDeveloperSymKey(CryptoToken token, String keyType, String keySet, byte[] inputKeyArray, String keyAlg) throws EBaseException {
        SymmetricKey devKey = null;
        String method = "SecureChannelProtocol.returnDeveloperSymKey:";
        boolean isAES = false;
        String finalAlg = null;
        if (keyAlg == null) {
            finalAlg = "DES3";
        }
        if (keyAlg.equalsIgnoreCase("AES")) {
            isAES = true;
            finalAlg = "AES";
        }
        String devKeyName = keySet + "-" + keyType + "Key-" + finalAlg;
        logger.debug(method + " entering.. searching for key: " + devKeyName);
        if (token == null || keyType == null || keySet == null) {
            throw new EBaseException(method + "Invalid input data!");
        }
        try {
            logger.debug(method + " requested token: " + token.getName());
        }
        catch (TokenException e) {
            throw new EBaseException(method + e);
        }
        devKey = SecureChannelProtocol.getSymKeyByName(token, devKeyName);
        if (devKey == null) {
            byte[] des3InputKey = null;
            if (inputKeyArray == null) {
                throw new EBaseException(method + "Input key is null and has to be non null when importing...");
            }
            int inputLen = inputKeyArray.length;
            logger.debug(method + " inputKeyArray.length: " + inputLen);
            if (!isAES) {
                if (inputLen != 24 && inputLen != 16) {
                    throw new EBaseException(method + "invalid input key length!");
                }
                if (inputLen == 16) {
                    des3InputKey = new byte[24];
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 0, 16);
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 16, 8);
                } else {
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 0, 24);
                }
                devKey = this.unwrapSymKeyOnToken(token, des3InputKey, true);
            } else if (inputLen == 16) {
                devKey = this.unwrapAESSymKeyOnToken(token, inputKeyArray, true);
            }
            devKey.setNickName(devKeyName);
        } else {
            logger.debug(method + " Found sym key: " + devKeyName);
        }
        return devKey;
    }

    public SymmetricKey unwrapAESSymKeyOnToken(CryptoToken token, byte[] inputKeyArray, boolean isPerm) throws EBaseException {
        SymmetricKey finalAESKey;
        String method = "SecureChannelProtocol.unwrapAESSymKeyOnToken:";
        logger.debug(method + "Entering...");
        if (token == null || inputKeyArray == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        if (inputKeyArray.length < 16) {
            throw new EBaseException(method + " Invalid key size!");
        }
        byte[] finalInputKeyArray = inputKeyArray;
        if (inputKeyArray.length > 16) {
            finalInputKeyArray = new byte[16];
            System.arraycopy(inputKeyArray, 0, finalInputKeyArray, 0, 16);
        }
        try {
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
            SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
            kg.setKeyUsages(usages);
            kg.temporaryKeys(true);
            kg.initialize(128);
            SymmetricKey tempKey = kg.generate();
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
            byte[] iv = null;
            if (ivLength > 0) {
                iv = new byte[ivLength];
            }
            encryptor.initEncrypt(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            byte[] wrappedKey = encryptor.doFinal(finalInputKeyArray);
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyWrap.initUnwrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            finalAESKey = isPerm ? keyWrap.unwrapSymmetricPerm(wrappedKey, SymmetricKey.AES, 16) : keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, 16);
        }
        catch (Exception e) {
            throw new EBaseException(method + " Can't unwrap key onto token!");
        }
        return finalAESKey;
    }

    public SymmetricKey unwrapAESSymKeyOnToken(CryptoToken token, SymmetricKey keyToUnwrap, boolean isPerm) throws EBaseException {
        SymmetricKey finalAESKey;
        String method = "SecureChannelProtocol.unwrapAESSymKeyOnToken:";
        logger.debug(method + "Entering...");
        if (token == null || keyToUnwrap == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        if (keyToUnwrap.getLength() < 16) {
            throw new EBaseException(method + " Invalid key size!");
        }
        TPSEngine engine = TPSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        try {
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
            SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
            kg.setKeyUsages(usages);
            kg.temporaryKeys(true);
            kg.initialize(128);
            SymmetricKey tempKey = kg.generate();
            int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
            byte[] iv = null;
            if (ivLength > 0) {
                iv = new byte[ivLength];
            }
            int len = keyToUnwrap.getLength();
            SymmetricKey finalKeyToWrap = null;
            SymmetricKey key16 = null;
            if (len > 16) {
                key16 = this.extractDes2FromDes3(keyToUnwrap, token.getName());
                if (key16 != null) {
                    len = key16.getLength();
                }
                finalKeyToWrap = key16;
            } else {
                finalKeyToWrap = keyToUnwrap;
            }
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyWrap.initWrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            byte[] wrappedKey = keyWrap.wrap(finalKeyToWrap);
            KeyWrapper keyUnWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyUnWrap.initUnwrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            finalAESKey = keyUnWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, 16);
            jssSubsystem.obscureBytes(wrappedKey);
        }
        catch (Exception e) {
            throw new EBaseException(method + " Can't unwrap key onto token!");
        }
        return finalAESKey;
    }

    public SymmetricKey unwrapSymKeyOnToken(CryptoToken token, SymmetricKey unwrappingKey, byte[] inputKeyArray, boolean isPerm, SymmetricKey.Type finalKeyType) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        SymmetricKey tempKey = null;
        if (token == null) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (inputKeyArray == null || inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        if (unwrappingKey == null) {
            try {
                KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES3);
                SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
                kg.setKeyUsages(usages);
                kg.temporaryKeys(true);
                tempKey = kg.generate();
            }
            catch (CharConversionException | IllegalStateException | NoSuchAlgorithmException | TokenException e) {
                throw new EBaseException(method + "Can't generate temporary key to unwrap the key.");
            }
        }
        byte[] finalKeyArray = null;
        if (inputKeyArray.length == 16 && finalKeyType == SymmetricKey.DES3) {
            finalKeyArray = SecureChannelProtocol.makeDes3FromDes2(inputKeyArray);
        }
        Cipher encryptor = null;
        byte[] wrappedKey = null;
        SymmetricKey encUnwrapKey = null;
        encUnwrapKey = tempKey != null ? tempKey : unwrappingKey;
        try {
            encryptor = token.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            encryptor.initEncrypt(encUnwrapKey);
            wrappedKey = finalKeyArray != null ? (finalKeyType == SymmetricKey.Type.DES3 || finalKeyType == SymmetricKey.Type.DES ? encryptor.doFinal(SecureChannelProtocol.getDesParity(finalKeyArray)) : encryptor.doFinal(finalKeyArray)) : (finalKeyType == SymmetricKey.Type.DES3 || finalKeyType == SymmetricKey.Type.DES ? encryptor.doFinal(SecureChannelProtocol.getDesParity(inputKeyArray)) : encryptor.doFinal(inputKeyArray));
            logger.debug(method + " done enrypting data");
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
            keyWrap.initUnwrap(encUnwrapKey, null);
            unwrapped = isPerm ? keyWrap.unwrapSymmetricPerm(wrappedKey, finalKeyType, 0) : keyWrap.unwrapSymmetric(wrappedKey, finalKeyType, 0);
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        finally {
            if (finalKeyArray != null) {
                Arrays.fill(finalKeyArray, (byte)0);
            }
        }
        logger.debug(method + "Returning symkey...");
        return unwrapped;
    }

    public SymmetricKey unwrapWrappedSymKeyOnToken(CryptoToken token, SymmetricKey unwrappingKey, byte[] inputKeyArray, boolean isPerm, SymmetricKey.Type keyType) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapWrappedSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        SymmetricKey finalUnwrapped = null;
        if (token == null || unwrappingKey == null) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (inputKeyArray == null) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        if (keyType == SymmetricKey.Type.AES ? inputKeyArray.length != 16 : (keyType == SymmetricKey.Type.DES || keyType == SymmetricKey.Type.DES3) && inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "Invalid length of raw input array.");
        }
        try {
            KeyWrapper keyWrap;
            if (unwrappingKey.getType() == SymmetricKey.Type.AES) {
                IVParameterSpec iv = new IVParameterSpec(new byte[EncryptionAlgorithm.AES_128_CBC.getIVLength()]);
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
                keyWrap.initUnwrap(unwrappingKey, (AlgorithmParameterSpec)iv);
            } else if (unwrappingKey.getType() == SymmetricKey.Type.DES || unwrappingKey.getType() == SymmetricKey.Type.DES3) {
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
                keyWrap.initUnwrap(unwrappingKey, null);
            } else {
                throw new EBaseException(method + " Unsupported transport key type.");
            }
            unwrapped = isPerm ? keyWrap.unwrapSymmetricPerm(inputKeyArray, keyType, SymmetricKey.Usage.UNWRAP, inputKeyArray.length) : keyWrap.unwrapSymmetric(inputKeyArray, keyType, SymmetricKey.Usage.UNWRAP, inputKeyArray.length);
            if (keyType == SymmetricKey.DES3) {
                finalUnwrapped = this.makeDes3KeyDerivedFromDes2(unwrapped, token.getName());
            }
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        logger.debug(method + "Returning symkey...");
        return finalUnwrapped == null ? unwrapped : finalUnwrapped;
    }

    public SymmetricKey unwrapSymKeyOnToken(CryptoToken token, byte[] inputKeyArray, boolean isPerm) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        if (token == null) {
            throw new EBaseException(method + "Invalide crypto token!");
        }
        if (inputKeyArray == null || inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        SymmetricKey transport = this.getSharedSecretKey(token);
        unwrapped = this.unwrapSymKeyOnToken(token, transport, inputKeyArray, isPerm, SymmetricKey.DES3);
        return unwrapped;
    }

    public static SymmetricKey getSymKeyByName(CryptoToken token, String name) throws EBaseException {
        SymmetricKey[] keys;
        String method = "SecureChannelProtocol.getSymKeyByName:";
        if (token == null || name == null) {
            throw new EBaseException(method + "Invalid input data!");
        }
        logger.debug(method + "Searching for sym key: " + name);
        try {
            keys = token.getCryptoStore().getSymmetricKeys();
        }
        catch (TokenException e) {
            throw new EBaseException(method + "Can't get the list of symmetric keys!");
        }
        for (SymmetricKey cur : keys) {
            if (cur == null || !name.equals(cur.getNickName())) continue;
            logger.debug(method + "Found key: " + name);
            return cur;
        }
        logger.debug(method + " Sym Key not found.");
        return null;
    }

    public CryptoToken returnTokenByName(String name, CryptoManager manager) throws NoSuchTokenException, NotInitializedException {
        logger.debug("returnTokenByName: requested name: " + name);
        if (name == null || manager == null) {
            throw new NoSuchTokenException();
        }
        return CryptoUtil.getKeyStorageToken((String)name);
    }

    public static byte[] makeDes3FromDes2(byte[] des2) {
        if (des2 == null || des2.length != 16) {
            return null;
        }
        byte[] des3 = new byte[24];
        System.arraycopy(des2, 0, des3, 0, 16);
        System.arraycopy(des2, 0, des3, 16, 8);
        return des3;
    }

    public static void debugByteArray(byte[] array, String message) {
        logger.debug("About to dump array: " + message);
        System.out.println("About to dump array: " + message);
        if (array == null) {
            logger.debug("Array to dump is empty!");
            return;
        }
        System.out.println("################### ");
        logger.debug("################### ");
        String result = SecureChannelProtocol.getHexString(array);
        logger.debug(result);
        System.out.println(result);
    }

    public static void displayByteArray(byte[] ba, boolean has_check_sum) {
        int mask = 255;
        if (has_check_sum) {
            mask = 254;
        }
        for (int i = 0; i < ba.length; ++i) {
            System.out.print(Integer.toHexString(ba[i] & mask) + " ");
            if (i % 26 != 25) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    public static String getHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 3];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3] = hex[v >>> 4];
            hexChars[j * 3 + 1] = hex[v & 0xF];
            hexChars[j * 3 + 2] = 58;
        }
        return new String(hexChars);
    }

    public CryptoManager getCryptoManger() throws EBaseException {
        String method = "SecureChannelProtocol.getCryptoManager";
        CryptoManager cm = null;
        if (this.cryptoManager != null) {
            return this.cryptoManager;
        }
        try {
            cm = CryptoManager.getInstance();
        }
        catch (NotInitializedException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        this.cryptoManager = cm;
        return this.cryptoManager;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public SymmetricKey generateSymKey(String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.generateSymKey:";
        logger.debug(method + " entering , token: " + selectedToken);
        SymmetricKey symKey = null;
        SymmetricKey symKeyFinal = null;
        if (selectedToken == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES3);
            symKey = kg.generate();
            symKeyFinal = this.makeDes3KeyDerivedFromDes2(symKey, selectedToken);
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return symKeyFinal;
    }

    public SymmetricKey makeDes3KeyDerivedFromDes2(SymmetricKey des3Key, String selectedToken) throws EBaseException {
        SymmetricKey des3 = null;
        String method = "SecureChannelProtocol.makeDes3KeyDerivedFromDes2:";
        logger.debug(method + " Entering ...");
        if (des3Key == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            long bitPosition = 0L;
            byte[] param = SecureChannelProtocol.longToBytes(bitPosition);
            SymmetricKey extracted16 = this.extractDes2FromDes3(des3Key, selectedToken);
            SymmetricKeyDeriver extract8 = token.getSymmetricKeyDeriver();
            extract8.initDerive(extracted16, 869L, param, null, 260L, 268L, 8L);
            SymmetricKey extracted8 = extract8.derive();
            logger.debug(method + " extracted8 key");
            SymmetricKeyDeriver concat = token.getSymmetricKeyDeriver();
            concat.initDerive(extracted16, extracted8, 864L, null, null, 306L, 268L, 0L);
            des3 = concat.derive();
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return des3;
    }

    public SymmetricKey extractDes2FromDes3(SymmetricKey baseKey, String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.extractDes2FromDes3:";
        logger.debug(method + " Entering: ");
        SymmetricKey extracted16 = null;
        if (baseKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            long bitPosition = 0L;
            byte[] param = SecureChannelProtocol.longToBytes(bitPosition);
            SymmetricKeyDeriver extract16 = token.getSymmetricKeyDeriver();
            extract16.initDerive(baseKey, 869L, param, null, 260L, 268L, 16L);
            extracted16 = extract16.derive();
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return extracted16;
    }

    public byte[] wrapSessionKey(String tokenName, SymmetricKey sessionKey, SymmetricKey wrappingKey) throws EBaseException {
        String method = "SecureChannelProtocol.wrapSessionKey";
        KeyWrapper keyWrap = null;
        byte[] wrappedSessKeyData = null;
        if (tokenName == null || sessionKey == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        SymmetricKey wrapper = null;
        wrapper = wrappingKey == null ? this.transportKey : wrappingKey;
        logger.debug(method + " wrapper key type: " + wrapper.getType());
        if (wrapper.getType() != SymmetricKey.AES) {
            logger.debug(method + "Trying to wrap a key with an DES key!");
            try {
                CryptoManager cm = this.getCryptoManger();
                CryptoToken token = this.returnTokenByName(tokenName, cm);
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
                keyWrap.initWrap(wrapper, null);
                wrappedSessKeyData = keyWrap.wrap(sessionKey);
            }
            catch (Exception e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        if (wrapper.getType() == SymmetricKey.AES) {
            logger.debug(method + "Trying to wrap a key with an AES key!");
            try {
                CryptoManager cm = this.getCryptoManger();
                CryptoToken token = this.returnTokenByName(tokenName, cm);
                int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
                byte[] iv = null;
                if (ivLength > 0) {
                    iv = new byte[ivLength];
                }
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
                keyWrap.initWrap(wrapper, (AlgorithmParameterSpec)new IVParameterSpec(iv));
                wrappedSessKeyData = keyWrap.wrap(sessionKey);
            }
            catch (Exception e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        logger.debug(method + " returning session key");
        return wrappedSessKeyData;
    }

    public byte[] computeAES_CBCEncryption(SymmetricKey symKey, String selectedToken, byte[] input, byte[] iv) throws EBaseException {
        String method = "SecureChannelProtocol.computeAES_CBCEncryption";
        byte[] output = null;
        byte[] finalIv = null;
        if (symKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        finalIv = iv == null ? new byte[16] : iv;
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            encryptor.initEncrypt(symKey, (AlgorithmParameterSpec)new IVParameterSpec(finalIv));
            output = encryptor.doFinal(input);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + e);
        }
        return output;
    }

    public static byte[] getDesParity(byte[] key) throws EBaseException {
        String method = "KDF.getDesParity";
        if (key == null || key.length != 16 && key.length != 8 && key.length != 24) {
            throw new EBaseException(method + " Incorrect input key !");
        }
        byte[] desKey = new byte[key.length];
        for (int i = 0; i < key.length; ++i) {
            byte val;
            int index = key[i] & 0xFF;
            int finalIndex = index >> 1;
            desKey[i] = val = (byte)parityTable[finalIndex];
        }
        logger.debug(method + "desKey: len: " + desKey.length);
        return desKey;
    }

    public static TPSBuffer compute_AES_CMAC_Cryptogram(SymmetricKey symKey, TPSBuffer context, byte kdfConstant) throws EBaseException {
        String method = "SecureChannelProtocol.compute_AES_Crypto:";
        byte[] label = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (symKey == null || context == null) {
            throw new EBaseException(method + " Invalid input!");
        }
        TPSBuffer data = new TPSBuffer();
        int outputBits = 64;
        int h = 128;
        int remainder = outputBits % 128;
        int n = 0;
        n = remainder == 0 ? outputBits / 128 : outputBits / 128 + 1;
        byte b1 = (byte)(outputBits >> 8 & 0xFF);
        byte b2 = (byte)(outputBits & 0xFF);
        TPSBuffer outputBitsBinary = new TPSBuffer(2);
        outputBitsBinary.setAt(0, b1);
        outputBitsBinary.setAt(1, b2);
        data.addBytes(label);
        data.add(kdfConstant);
        data.add((byte)0);
        data.add(outputBitsBinary);
        TPSBuffer output = new TPSBuffer();
        TPSBuffer input = new TPSBuffer();
        TPSBuffer kI = null;
        for (int i = 1; i <= n; ++i) {
            input.add(data);
            input.add((byte)i);
            input.add(context);
            kI = SecureChannelProtocol.computeAES_CMAC(symKey, input);
            output.add(kI);
        }
        return output.substr(0, 8);
    }

    public static TPSBuffer computeAES_CMAC(SymmetricKey aesKey, TPSBuffer input) throws EBaseException {
        String method = "SecureChannelProtocol.computeAES_CMAC:";
        byte[] iv = null;
        if (aesKey == null || input == null) {
            throw new EBaseException(method + " invalid input data!");
        }
        TPSBuffer data = new TPSBuffer(input);
        String alg = aesKey.getAlgorithm();
        System.out.println(" AES ALG: " + alg);
        EncryptionAlgorithm eAlg = EncryptionAlgorithm.AES_128_CBC;
        int ivLength = eAlg.getIVLength();
        if (ivLength > 0) {
            iv = new byte[ivLength];
        }
        if (!"AES".equals(alg)) {
            throw new EBaseException(method + " invalid in put key type , must be AES!");
        }
        byte[] k0 = new byte[16];
        CryptoToken token = aesKey.getOwningToken();
        Cipher encryptor = null;
        try {
            encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            encryptor.initEncrypt(aesKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            k0 = encryptor.doFinal(k0);
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | TokenException e) {
            throw new EBaseException((Exception)e);
        }
        byte[] k1 = SecureChannelProtocol.getAES_CMAC_SubKey(k0);
        byte[] k2 = SecureChannelProtocol.getAES_CMAC_SubKey(k1);
        int numBlocks = 0;
        int messageSize = data.size();
        boolean perfectBlocks = false;
        if (messageSize % 16 == 0 && messageSize != 0) {
            numBlocks = messageSize / 16;
            perfectBlocks = true;
        } else {
            numBlocks = messageSize / 16 + 1;
            perfectBlocks = false;
        }
        int index = 0;
        byte inb = 0;
        if (perfectBlocks) {
            for (int j = 0; j < k1.length; ++j) {
                index = messageSize - 16 + j;
                inb = data.at(index);
                data.setAt(index, (byte)(inb ^ k1[j]));
            }
        } else {
            TPSBuffer padding = new TPSBuffer(16 - messageSize % 16);
            padding.setAt(0, (byte)-128);
            data.add(padding);
            messageSize = data.size();
            for (int j = 0; j < k2.length; ++j) {
                index = messageSize - 16 + j;
                inb = data.at(index);
                data.setAt(index, (byte)(inb ^ k2[j]));
            }
        }
        byte[] encData = new byte[16];
        TPSBuffer currentBlock = null;
        for (int i = 0; i < numBlocks; ++i) {
            try {
                encryptor.initEncrypt(aesKey, (AlgorithmParameterSpec)new IVParameterSpec(encData));
                currentBlock = data.substr(i * 16, 16);
                encData = encryptor.doFinal(currentBlock.toBytesArray());
                continue;
            }
            catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | TokenException e) {
                throw new EBaseException((Exception)e);
            }
        }
        TPSBuffer aesMacData = new TPSBuffer(encData);
        return aesMacData;
    }

    private static byte[] getAES_CMAC_SubKey(byte[] input) {
        byte[] output = new byte[input.length];
        boolean msbSet = (input[0] & 0x80) != 0;
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)(input[i] << 1);
            if (i + 1 >= input.length || (input[i + 1] & 0x80) == 0) continue;
            int n = i;
            output[n] = (byte)(output[n] | 1);
        }
        if (msbSet) {
            int n = output.length - 1;
            output[n] = (byte)(output[n] ^ 0xFFFFFF87);
        }
        return output;
    }

    public static void setDefaultPrefix(String masterkeyPrefix) {
        if (masterKeyPrefix == null) {
            masterKeyPrefix = masterkeyPrefix;
        }
    }

    public static void main(String[] args) {
    }
}

