/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.logging.ActivityCollection;
import com.netscape.certsrv.logging.ActivityData;
import com.netscape.certsrv.logging.ActivityResource;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.usrgrp.User;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.dbs.ActivityDatabase;
import org.dogtagpki.server.tps.dbs.ActivityRecord;
import org.dogtagpki.server.tps.dbs.TokenDatabase;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityService
extends PKIService
implements ActivityResource {
    public static Logger logger = LoggerFactory.getLogger(ActivityService.class);

    public ActivityService() {
        logger.debug("ActivityService.<init>()");
    }

    public ActivityData createActivityData(ActivityRecord activityRecord) {
        ActivityData activityData = new ActivityData();
        activityData.setID(activityRecord.getId());
        activityData.setTokenID(activityRecord.getTokenID());
        activityData.setUserID(activityRecord.getUserID());
        activityData.setIP(activityRecord.getIP());
        activityData.setOperation(activityRecord.getOperation());
        activityData.setResult(activityRecord.getResult());
        activityData.setMessage(activityRecord.getMessage());
        activityData.setDate(activityRecord.getDate());
        String activityID = activityRecord.getId();
        try {
            activityID = URLEncoder.encode(activityID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
        return activityData;
    }

    public ActivityData createRestrictedActivityData() {
        ActivityData activityData = new ActivityData();
        activityData.setID("<restricted>");
        activityData.setTokenID("<restricted>");
        activityData.setUserID("<restricted>");
        activityData.setIP("<restricted>");
        activityData.setOperation("<restricted>");
        activityData.setResult("<restricted>");
        activityData.setMessage("<restricted>");
        activityData.setDate(new Date(0L));
        return activityData;
    }

    public ActivityRecord createActivityRecord(ActivityData activityData) {
        ActivityRecord activityRecord = new ActivityRecord();
        activityRecord.setId(activityData.getID());
        activityRecord.setTokenID(activityData.getTokenID());
        activityRecord.setUserID(activityData.getUserID());
        activityRecord.setIP(activityData.getIP());
        activityRecord.setOperation(activityData.getOperation());
        activityRecord.setResult(activityData.getResult());
        activityRecord.setMessage(activityData.getMessage());
        activityRecord.setDate(activityData.getDate());
        return activityRecord;
    }

    public Response findActivities(String filter, Integer start, Integer size) {
        String method = "ActivityService.findActivities: ";
        logger.debug(method);
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ActivityDatabase database = subsystem.getActivityDatabase();
            ActivityCollection response = new ActivityCollection();
            if (filter == null) {
                this.retrieveActivitiesWithVLV(database, start, size, response);
            } else {
                this.retrieveActivitiesWithoutVLV(database, filter, start, size, response);
            }
            return this.createOKResponse(response);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage());
        }
    }

    protected void retrieveActivitiesWithVLV(ActivityDatabase database, Integer start, Integer size, ActivityCollection response) throws Exception {
        String method = "ActivityService.retrieveActivitiesWithVLV: ";
        logger.debug(method);
        DBVirtualList list = database.findRecords(null, null, new String[]{"-date"}, size);
        List<String> authorizedProfiles = this.getAuthorizedProfiles();
        int total = list.getSize();
        logger.debug(method + "total: " + total);
        int retTotal = 0;
        if (authorizedProfiles != null) {
            if (authorizedProfiles.contains("All Profiles")) {
                for (int i = start.intValue(); i < start + size && i < total; ++i) {
                    ActivityRecord record = (ActivityRecord)list.getElementAt(i);
                    if (record == null) {
                        logger.error("ActivityService: Activity record not found");
                        throw new PKIException("Activity record not found");
                    }
                    response.addEntry((Object)this.createActivityData(record));
                    ++retTotal;
                }
            } else {
                for (int i = start.intValue(); i < start + size && i < total; ++i) {
                    ActivityRecord record = (ActivityRecord)list.getElementAt(i);
                    String type = record.getType();
                    if (type == null || type.isEmpty()) {
                        TPSEngine engine;
                        TPSSubsystem subsystem;
                        TokenDatabase t_database;
                        TokenRecord t_record;
                        logger.debug(method + "record.tokenType null...getting from token record");
                        String tokenID = record.getTokenID();
                        if (tokenID != null && !tokenID.isEmpty() && (t_record = (TokenRecord)(t_database = (subsystem = (TPSSubsystem)(engine = TPSEngine.getInstance()).getSubsystem("tps")).getTokenDatabase()).getRecord(tokenID)) != null) {
                            type = t_record.getType();
                        }
                    }
                    if (type == null || type.isEmpty() || authorizedProfiles.contains(type)) {
                        ++retTotal;
                        response.addEntry((Object)this.createActivityData(record));
                        continue;
                    }
                    logger.debug(method + "token type restricted; adding 'restricted' record");
                    response.addEntry((Object)this.createRestrictedActivityData());
                }
            }
        } else {
            logger.debug(method + "authorized profiles is null");
        }
        logger.debug(method + "retTotal = " + retTotal);
        response.setTotal(total);
    }

    protected void retrieveActivitiesWithoutVLV(ActivityDatabase database, String filter, Integer start, Integer size, ActivityCollection response) throws Exception {
        String method = "ActivityService.retrieveActivitiesWithoutVLV: ";
        List activities = (List)database.findRecords(filter);
        int total = activities.size();
        logger.debug(method + "total: " + total);
        List<String> authorizedProfiles = this.getAuthorizedProfiles();
        int retTotal = 0;
        int i = 0;
        if (authorizedProfiles != null) {
            if (authorizedProfiles.contains("All Profiles")) {
                for (i = start.intValue(); i < start + size && i < total; ++i) {
                    ActivityRecord record = (ActivityRecord)((Object)activities.get(i));
                    response.addEntry((Object)this.createActivityData(record));
                    ++retTotal;
                }
            } else {
                for (i = start.intValue(); i < start + size && i < total; ++i) {
                    ActivityRecord record = (ActivityRecord)((Object)activities.get(i));
                    String type = record.getType();
                    if (type == null || type.isEmpty()) {
                        TPSEngine engine;
                        TPSSubsystem subsystem;
                        TokenDatabase t_database;
                        TokenRecord t_record;
                        logger.debug(method + "record.tokenType null...getting from token record");
                        String tokenID = record.getTokenID();
                        if (tokenID != null && !tokenID.isEmpty() && (t_record = (TokenRecord)(t_database = (subsystem = (TPSSubsystem)(engine = TPSEngine.getInstance()).getSubsystem("tps")).getTokenDatabase()).getRecord(tokenID)) != null) {
                            type = t_record.getType();
                        }
                    }
                    if (type == null || type.isEmpty() || authorizedProfiles.contains(type)) {
                        ++retTotal;
                        response.addEntry((Object)this.createActivityData(record));
                        continue;
                    }
                    response.addEntry((Object)this.createRestrictedActivityData());
                }
            }
        } else {
            logger.debug(method + "authorized profiles is null");
        }
        logger.debug(method + "retTotal = " + retTotal);
        response.setTotal(total);
    }

    public Response getActivity(String activityID) {
        String method = "ActivityService.getActivity: ";
        Object msg = "";
        if (activityID == null) {
            throw new BadRequestException("Activity ID is null.");
        }
        logger.debug(method + "(\"" + activityID + "\")");
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            TPSEngine engine = TPSEngine.getInstance();
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ActivityDatabase database = subsystem.getActivityDatabase();
            ActivityRecord record = (ActivityRecord)database.getRecord(activityID);
            if (record == null) {
                logger.debug(method + "record not found");
                throw new PKIException(method + "record not found");
            }
            String type = record.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                msg = "token type restricted: " + type;
                logger.debug(method + (String)msg);
                throw new PKIException((String)msg);
            }
            return this.createOKResponse(this.createActivityData(record));
        }
        catch (Exception e) {
            logger.debug(method + e.toString());
            throw new PKIException(e.getMessage());
        }
    }

    List<String> getAuthorizedProfiles() throws Exception {
        String method = "ActivityService.getAuthorizedProfiles: ";
        PKIPrincipal pkiPrincipal = (PKIPrincipal)this.servletRequest.getUserPrincipal();
        if (pkiPrincipal == null) {
            logger.debug(method + "servletRequest.getUserPrincipal() returned null");
            return null;
        }
        User user = pkiPrincipal.getUser();
        return user.getTpsProfiles();
    }
}

