/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.ca.CAMissingCertException;
import com.netscape.certsrv.ca.CAMissingKeyException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.security.SigningUnit;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CASigningUnit
extends SigningUnit {
    public static Logger logger = LoggerFactory.getLogger(CASigningUnit.class);

    public void updateConfig(String nickname, String tokenname) {
        this.mConfig.setCACertNickname(nickname);
        this.mConfig.setTokenName(tokenname);
    }

    public void init(SigningUnitConfig config, String nickname) throws EBaseException {
        logger.debug("CASigningUnit.init(" + config.getName() + ", " + nickname + ")");
        this.mConfig = config;
        String tokenname = null;
        try {
            this.mManager = CryptoManager.getInstance();
            if (nickname == null) {
                try {
                    this.mNickname = this.mConfig.getCertNickname();
                }
                catch (EPropertyNotFound e) {
                    this.mNickname = this.mConfig.getCACertNickname();
                }
            } else {
                this.mNickname = nickname;
            }
            tokenname = config.getTokenName();
            this.mToken = CryptoUtil.getKeyStorageToken((String)tokenname);
            if (!CryptoUtil.isInternalToken((String)tokenname)) {
                this.mNickname = tokenname + ":" + this.mNickname;
            }
            this.setNewNickName(this.mNickname);
            try {
                logger.debug("SigningUnit: Loading certificate " + this.mNickname);
                this.mCert = this.mManager.findCertByNickname(this.mNickname);
                logger.debug("SigningUnit: certificate serial number: " + this.mCert.getSerialNumber());
            }
            catch (ObjectNotFoundException e) {
                throw new CAMissingCertException("Certificate not found: " + this.mNickname + ": " + e.getMessage(), (Exception)((Object)e));
            }
            this.buildCertChain();
            this.mCertImpl = new X509CertImpl(this.mCert.getEncoded());
            try {
                logger.debug("SigningUnit: Loading private key");
                this.mPrivk = this.mManager.findPrivKeyByCert(this.mCert);
            }
            catch (ObjectNotFoundException e) {
                throw new CAMissingKeyException("Private key not found: " + this.mNickname + ": " + e.getMessage(), (Exception)((Object)e));
            }
            String privateKeyID = "0x" + Utils.HexEncode((byte[])this.mPrivk.getUniqueID());
            logger.debug("SigningUnit: private key ID: " + privateKeyID);
            this.mPubk = this.mCert.getPublicKey();
            this.mDefSigningAlgname = config.getDefaultSigningAlgorithm();
            this.mDefSigningAlgorithm = this.checkSigningAlgorithmFromName(this.mDefSigningAlgname);
            logger.debug("SigningUnit: signing algorithm: " + this.mDefSigningAlgorithm);
            this.mInited = true;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_CA_CERT", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (NotInitializedException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_TOKEN_INIT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CRYPTO_NOT_INITIALIZED", (String[])new String[0]), (Throwable)e);
        }
        catch (NoSuchTokenException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_TOKEN_NOT_FOUND", (Object[])new Object[]{tokenname, e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_TOKEN_NOT_FOUND", (String[])new String[]{tokenname}), (Throwable)e);
        }
        catch (CAMissingCertException | CAMissingKeyException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_CERT_NOT_FOUND", (Object[])new Object[]{e.toString()}), e);
            throw e;
        }
        catch (TokenException e) {
            logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_TOKEN_ERROR", (String[])new String[0]), (Throwable)e);
        }
    }

    public byte[] sign(byte[] data, String algname) throws Exception {
        if (!this.mInited) {
            throw new EBaseException("CASigningUnit not initialized");
        }
        SignatureAlgorithm signAlg = this.mDefSigningAlgorithm;
        if (algname != null) {
            signAlg = this.checkSigningAlgorithmFromName(algname);
        }
        logger.info("CASigningUnit: Getting algorithm context for " + algname + " " + signAlg);
        Signature signer = this.mToken.getSignatureContext(signAlg);
        signer.initSign(this.mPrivk);
        signer.update(data);
        logger.info("CASigningUnit: Signing Certificate");
        boolean testSignatureFailure = this.mConfig.getTestSignatureFailure();
        if (testSignatureFailure) {
            throw new SignatureException("SignatureException forced for testing");
        }
        return signer.sign();
    }

    public boolean verify(byte[] data, byte[] signature, String algname) throws Exception {
        if (!this.mInited) {
            throw new EBaseException("CASigningUnit not initialized!");
        }
        SignatureAlgorithm signAlg = Cert.mapAlgorithmToJss((String)algname);
        if (signAlg == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_ALG_NOT_SUPPORTED", (Object[])new Object[]{algname, ""}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_ALGOR_NOT_SUPPORTED", (String[])new String[]{algname}));
        }
        Signature signer = this.mToken.getSignatureContext(signAlg);
        signer.initVerify(this.mPubk);
        signer.update(data);
        return signer.verify(signature);
    }
}

