/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.util.Date;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSInvalidityDateExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSInvalidityDateExtension.class);

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        InvalidityDateExtension invalidityDateExt = null;
        try {
            Date invalidityDate = ((InvalidityDateExtension)ext).getInvalidityDate();
            invalidityDateExt = new InvalidityDateExtension(Boolean.valueOf(critical), invalidityDate);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALIDITY_DATE_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return invalidityDateExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object crlIssuingPoint, boolean critical) {
        Extension invalidityDateExt = null;
        return invalidityDateExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.InvalidityDate_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Invalidity Date CRL entry extension.", "critical;boolean;Set criticality for Invalidity Date CRL entry extension.", "HELP_TOKEN;configuration-ca-edit-crlextension-invaliditydate", "HELP_TEXT;The invalidity date is a non-critical CRL entry extension that provides the date on which it is known or suspected that the private key was compromised or that the certificate otherwise became invalid."};
        return params;
    }
}

